/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ShapedButton;

abstract class NavButton
extends ShapedButton {
    protected final Path mBorderPath;
    protected final Paint mBorderPaint;
    protected final float mBorderWidth;
    protected final int mBorderColor;
    protected final int mBorderColorPrivate;

    public NavButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = this.getResources();
        this.mBorderColor = ContextCompat.getColor((Context)context, (int)R.color.disabled_grey);
        this.mBorderColorPrivate = ContextCompat.getColor((Context)context, (int)R.color.toolbar_icon_grey);
        this.mBorderWidth = resources.getDimension(R.dimen.nav_button_border_width);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPath = new Path();
        this.setPrivateMode(false);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mBorderPaint.setColor(bl ? this.mBorderColorPrivate : this.mBorderColor);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(this.mBorderPath, this.mBorderPaint);
    }

    @Override
    public void onLightweightThemeChanged() {
        LightweightThemeDrawable lightweightThemeDrawable = BrowserToolbar.getLightweightThemeDrawable((View)this, this.getTheme(), R.color.toolbar_grey);
        if (lightweightThemeDrawable == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_PRESSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.placeholder_active_grey));
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.toolbar_grey_pressed));
        stateListDrawable.addState(PRIVATE_FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.text_and_tabs_tray_grey));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.tablet_highlight_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.tabs_tray_grey_pressed));
        stateListDrawable.addState(EMPTY_STATE_SET, (Drawable)lightweightThemeDrawable);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_nav_button);
    }
}

