/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.themed.ThemedImageView;

public class ThumbnailView
extends ThemedImageView {
    private static final String LOGTAG = "GeckoThumbnailView";
    private final Matrix mMatrix = new Matrix();
    private int mWidthSpec = -1;
    private int mHeightSpec = -1;
    private boolean mLayoutChanged = true;
    private boolean mScale = false;

    public ThumbnailView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void onDraw(Canvas canvas) {
        int n;
        if (!this.mScale) {
            super.onDraw(canvas);
            return;
        }
        Drawable drawable2 = this.getDrawable();
        if (this.mLayoutChanged) {
            int n2;
            n = drawable2.getIntrinsicWidth();
            int n3 = drawable2.getIntrinsicHeight();
            int n4 = this.getWidth();
            float f = n4 / (n2 = this.getHeight()) < n / n3 ? (float)n2 / (float)n3 : (float)n4 / (float)n;
            this.mMatrix.setScale(f, f);
        }
        n = canvas.save();
        canvas.concat(this.mMatrix);
        drawable2.draw(canvas);
        canvas.restoreToCount(n);
    }

    protected void onMeasure(int n, int n2) {
        if (n != this.mWidthSpec || n2 != this.mHeightSpec) {
            this.mWidthSpec = n;
            this.mHeightSpec = n2;
            this.mLayoutChanged = true;
        }
        super.onMeasure(n, n2);
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.tab_panel_tab_background);
            this.setScaleType(ImageView.ScaleType.FIT_XY);
            this.mScale = false;
        } else {
            this.mScale = true;
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        super.setImageDrawable(drawable2);
    }
}

