/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.app.Activity;
import android.view.Window;
import org.mozilla.gecko.AppConstants;

public class ActivityUtils {
    private ActivityUtils() {
    }

    public static void setFullScreen(Activity activity, boolean bl) {
        Window window = activity.getWindow();
        if (AppConstants.Versions.feature16Plus) {
            int n;
            if (bl) {
                n = 4;
                n = AppConstants.Versions.feature19Plus ? (n |= 0x1702) : (n |= 1);
            } else {
                n = 0;
            }
            window.getDecorView().setSystemUiVisibility(n);
        } else {
            window.setFlags(bl ? 1024 : 0, 1024);
        }
    }

    public static boolean isFullScreen(Activity activity) {
        Window window = activity.getWindow();
        if (AppConstants.Versions.feature16Plus) {
            int n = window.getDecorView().getSystemUiVisibility();
            return (n & 4) != 0;
        }
        int n = window.getAttributes().flags;
        return (n & 0x400) != 0;
    }
}

