/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.NativeZip;

public final class GeckoJarReader {
    private static final String LOGTAG = "GeckoJarReader";

    private GeckoJarReader() {
    }

    public static Bitmap getBitmap(Context context, Resources resources, String string) {
        BitmapDrawable bitmapDrawable = GeckoJarReader.getBitmapDrawable(context, resources, string);
        return bitmapDrawable != null ? bitmapDrawable.getBitmap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapDrawable getBitmapDrawable(Context context, Resources resources, String string) {
        Stack<String> stack = GeckoJarReader.parseUrl(string);
        InputStream inputStream = null;
        BitmapDrawable bitmapDrawable = null;
        NativeZip nativeZip = null;
        try {
            nativeZip = GeckoJarReader.getZipFile(context, stack.pop());
            inputStream = GeckoJarReader.getStream(nativeZip, stack, string);
            if (inputStream != null) {
                bitmapDrawable = new BitmapDrawable(resources, inputStream);
                bitmapDrawable.setTargetDensity(resources.getDisplayMetrics());
            }
        }
        catch (IOException | URISyntaxException exception) {
            Log.e((String)LOGTAG, (String)"Exception ", (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"Error closing stream", (Throwable)iOException);
                }
            }
            if (nativeZip != null) {
                nativeZip.close();
            }
        }
        return bitmapDrawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(Context context, String string) {
        Stack<String> stack = GeckoJarReader.parseUrl(string);
        NativeZip nativeZip = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            nativeZip = GeckoJarReader.getZipFile(context, stack.pop());
            InputStream inputStream = GeckoJarReader.getStream(nativeZip, stack, string);
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException | URISyntaxException exception) {
            Log.e((String)LOGTAG, (String)"Exception ", (Throwable)exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"Error closing reader", (Throwable)iOException);
                }
            }
            if (nativeZip != null) {
                nativeZip.close();
            }
        }
        return string2;
    }

    private static NativeZip getZipFile(Context context, String string) throws IOException, URISyntaxException {
        URI uRI = new URI(string);
        GeckoLoader.loadMozGlue((Context)context);
        return new NativeZip(uRI.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public static File extractStream(Context context, String string, File file, String string2) throws IOException {
        InputStream inputStream = null;
        try {
            Comparable<URI> comparable;
            block21: {
                Object object;
                Comparable<URI> comparable2;
                try {
                    comparable2 = new URI(string);
                    if (comparable2 != null && ((URI)comparable2).getPath() != null && (object = new File(((URI)comparable2).getPath())) != null && ((File)object).exists()) {
                        inputStream = new FileInputStream((File)object);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (inputStream == null) {
                    inputStream = GeckoJarReader.getStream(context, string);
                }
                if (inputStream == null) {
                    comparable2 = null;
                    return comparable2;
                }
                comparable2 = File.createTempFile("extractStream", string2, file);
                object = null;
                try {
                    int n;
                    object = new FileOutputStream((File)comparable2);
                    byte[] byArray = new byte[8192];
                    while ((n = inputStream.read(byArray)) >= 0) {
                        ((OutputStream)object).write(byArray, 0, n);
                    }
                    comparable = comparable2;
                    if (object == null) break block21;
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        ((OutputStream)object).close();
                    }
                    throw throwable;
                }
                ((OutputStream)object).close();
            }
            return comparable;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)"Got exception closing stream; ignoring.", (Throwable)iOException);
                }
            }
        }
    }

    @RobocopTarget
    public static InputStream getStream(Context context, String string) {
        Stack<String> stack = GeckoJarReader.parseUrl(string);
        try {
            NativeZip nativeZip = GeckoJarReader.getZipFile(context, stack.pop());
            return GeckoJarReader.getStream(nativeZip, stack, string);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception getting input stream from jar URL: " + string), (Throwable)exception);
            return null;
        }
    }

    private static InputStream getStream(NativeZip nativeZip, Stack<String> stack, String string) {
        InputStream inputStream = null;
        while (!stack.empty()) {
            String string2 = stack.pop();
            if (inputStream != null) {
                try {
                    nativeZip = new NativeZip(inputStream);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string3 = "!!! BUG 849589 !!! origUrl=" + string;
                    Log.e((String)LOGTAG, (String)string3, (Throwable)illegalArgumentException);
                    throw new IllegalArgumentException(string3);
                }
            }
            if ((inputStream = nativeZip.getInputStream(string2)) != null) continue;
            Log.d((String)LOGTAG, (String)("No Entry for " + string2));
            return null;
        }
        return inputStream;
    }

    private static Stack<String> parseUrl(String string) {
        return GeckoJarReader.parseUrl(string, null);
    }

    private static Stack<String> parseUrl(String string, Stack<String> stack) {
        if (stack == null) {
            stack = new Stack();
        }
        if (string.startsWith("jar:")) {
            int n = string.lastIndexOf("!");
            String string2 = string.substring(4, n);
            stack.push(string.substring(n + 2));
            return GeckoJarReader.parseUrl(string2, stack);
        }
        stack.push(string);
        return stack;
    }

    public static String getJarURL(Context context, String string) {
        String string2 = context.getPackageResourcePath();
        return GeckoJarReader.computeJarURI(string2, string);
    }

    @RobocopTarget
    public static String computeJarURI(String string, String string2) {
        String string3 = new File(string).toURI().toString();
        return "jar:jar:" + string3 + "!/" + "assets/omni.ja" + "!/" + string2;
    }
}

