/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final String LOGTAG = "GeckoIOUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsumedInputStream readFully(InputStream inputStream, int n) {
        Object object = new byte[n];
        int n2 = 0;
        int n3 = 0;
        try {
            Object object2;
            while (n3 != -1) {
                if ((n2 += (n3 = inputStream.read((byte[])object, n2, ((byte[])object).length - n2))) != ((byte[])object).length) continue;
                object2 = new byte[n *= 2];
                System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                object = object2;
            }
            object2 = new ConsumedInputStream(n2 + 1, (byte[])object);
            return object2;
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error consuming input stream.", (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.e((String)LOGTAG, (String)"Error closing input stream.", (Throwable)iOException);
            }
        }
        return null;
    }

    public static byte[] truncateBytes(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static void safeStreamClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static class ConsumedInputStream {
        public final int consumedLength;
        private byte[] consumedData;

        public ConsumedInputStream(int n, byte[] byArray) {
            this.consumedLength = n;
            this.consumedData = byArray;
        }

        public byte[] getTruncatedData() {
            if (this.consumedData.length == this.consumedLength) {
                return this.consumedData;
            }
            this.consumedData = IOUtils.truncateBytes(this.consumedData, this.consumedLength);
            return this.consumedData;
        }

        public byte[] getData() {
            return this.consumedData;
        }
    }
}

