/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;

public class NetworkUtils {
    public static boolean isConnected(@NonNull Context context) {
        return NetworkUtils.isConnected((ConnectivityManager)context.getSystemService("connectivity"));
    }

    public static boolean isConnected(ConnectivityManager connectivityManager) {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static ConnectionSubType getConnectionSubType(ConnectivityManager connectivityManager) {
        if (connectivityManager == null) {
            return ConnectionSubType.UNKNOWN;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return ConnectionSubType.UNKNOWN;
        }
        switch (networkInfo.getType()) {
            case 9: {
                return ConnectionSubType.ETHERNET;
            }
            case 0: {
                return NetworkUtils.getGenericMobileSubtype(networkInfo.getSubtype());
            }
            case 6: {
                return ConnectionSubType.WIMAX;
            }
            case 1: {
                return ConnectionSubType.WIFI;
            }
        }
        return ConnectionSubType.UNKNOWN;
    }

    public static ConnectionType getConnectionType(ConnectivityManager connectivityManager) {
        if (connectivityManager == null) {
            return ConnectionType.NONE;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return ConnectionType.NONE;
        }
        switch (networkInfo.getType()) {
            case 7: {
                return ConnectionType.BLUETOOTH;
            }
            case 9: {
                return ConnectionType.ETHERNET;
            }
            case 0: 
            case 6: {
                return ConnectionType.CELLULAR;
            }
            case 1: {
                return ConnectionType.WIFI;
            }
        }
        return ConnectionType.OTHER;
    }

    public static NetworkStatus getNetworkStatus(ConnectivityManager connectivityManager) {
        if (connectivityManager == null) {
            return NetworkStatus.UNKNOWN;
        }
        if (NetworkUtils.isConnected(connectivityManager)) {
            return NetworkStatus.UP;
        }
        return NetworkStatus.DOWN;
    }

    private static ConnectionSubType getGenericMobileSubtype(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return ConnectionSubType.CELL_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return ConnectionSubType.CELL_3G;
            }
            case 13: {
                return ConnectionSubType.CELL_4G;
            }
        }
        return ConnectionSubType.UNKNOWN;
    }

    public static enum ConnectionType {
        CELLULAR(0),
        BLUETOOTH(1),
        ETHERNET(2),
        WIFI(3),
        OTHER(4),
        NONE(5);

        public final int value;

        private ConnectionType(int n2) {
            this.value = n2;
        }
    }

    public static enum NetworkStatus {
        UP("up"),
        DOWN("down"),
        UNKNOWN("unknown");

        public final String value;

        private NetworkStatus(String string2) {
            this.value = string2;
        }
    }

    public static enum ConnectionSubType {
        CELL_2G("2g"),
        CELL_3G("3g"),
        CELL_4G("4g"),
        ETHERNET("ethernet"),
        WIFI("wifi"),
        WIMAX("wimax"),
        UNKNOWN("unknown");

        public final String value;

        private ConnectionSubType(String string2) {
            this.value = string2;
        }
    }
}

