/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Exchanger;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.WebRTCJNITarget;
import org.webrtc.videoengine.ViERenderer;
import org.webrtc.videoengine.VideoCaptureDeviceInfoAndroid;

public class VideoCaptureAndroid
implements Camera.PreviewCallback,
SurfaceHolder.Callback,
GeckoAppShell.AppStateListener {
    private static final String TAG = "WEBRTC-JC";
    private static SurfaceHolder localPreview;
    Camera camera;
    private Camera.CameraInfo info;
    private CameraThread cameraThread;
    private Handler cameraThreadHandler;
    private Context context;
    private final int id;
    private volatile long native_capturer;
    private SurfaceTexture cameraSurfaceTexture;
    private int[] cameraGlTextures = null;
    private final int numCaptureBuffers = 3;
    volatile int mCaptureRotation;
    int mCaptureWidth;
    int mCaptureHeight;
    int mCaptureMinFPS;
    int mCaptureMaxFPS;
    boolean mResumeCapture;
    private double averageDurationMs;
    private long lastCaptureTimeMs;
    private int frameCount;
    private int frameDropRatio;

    public static void setLocalPreview(SurfaceHolder surfaceHolder) {
        localPreview = surfaceHolder;
    }

    @WebRTCJNITarget
    public VideoCaptureAndroid(int n, long l) {
        this.id = n;
        this.native_capturer = l;
        this.context = VideoCaptureAndroid.GetContext();
        if (Build.VERSION.SDK_INT > 8) {
            this.info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)this.info);
        }
        this.mCaptureRotation = this.GetRotateAmount();
    }

    public synchronized void onPause() {
        if (this.camera != null) {
            this.mResumeCapture = true;
            this.stopCapture();
        }
    }

    public synchronized void onResume() {
        if (this.mResumeCapture) {
            this.startCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureMinFPS, this.mCaptureMaxFPS);
            this.mResumeCapture = false;
        }
    }

    public void onOrientationChanged() {
        this.mCaptureRotation = this.GetRotateAmount();
    }

    public int GetRotateAmount() {
        int n = GeckoAppShell.getGeckoInterface().getActivity().getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        if (Build.VERSION.SDK_INT > 8) {
            int n3 = this.info.facing == 1 ? (this.info.orientation + n2) % 360 : (this.info.orientation - n2 + 360) % 360;
            return n3;
        }
        int n4 = 90;
        int n5 = (n4 - n2 + 360) % 360;
        return n5;
    }

    private static native Context GetContext();

    @WebRTCJNITarget
    private synchronized boolean startCapture(final int n, final int n2, final int n3, final int n4) {
        Log.d((String)TAG, (String)("startCapture: " + n + "x" + n2 + "@" + n3 + ":" + n4));
        if (this.cameraThread != null || this.cameraThreadHandler != null) {
            throw new RuntimeException("Camera thread already started!");
        }
        Exchanger<Handler> exchanger = new Exchanger<Handler>();
        this.cameraThread = new CameraThread(exchanger);
        this.cameraThread.start();
        this.cameraThreadHandler = VideoCaptureAndroid.exchange(exchanger, null);
        final Exchanger exchanger2 = new Exchanger();
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureAndroid.this.startCaptureOnCameraThread(n, n2, n3, n4, exchanger2);
            }
        });
        boolean bl = VideoCaptureAndroid.exchange(exchanger2, false);
        return bl;
    }

    private void startCaptureOnCameraThread(int n, int n2, int n3, int n4, Exchanger<Boolean> exchanger) {
        if (!this.mResumeCapture) {
            ViERenderer.CreateLocalRenderer();
        }
        Exception exception = null;
        try {
            int n5;
            int n6;
            List list;
            this.camera = Build.VERSION.SDK_INT > 8 ? Camera.open((int)this.id) : Camera.open();
            localPreview = ViERenderer.GetLocalRenderer();
            if (localPreview != null) {
                localPreview.addCallback((SurfaceHolder.Callback)this);
                if (localPreview.getSurface() != null && localPreview.getSurface().isValid()) {
                    this.camera.setPreviewDisplay(localPreview);
                }
            } else if (Build.VERSION.SDK_INT > 10) {
                try {
                    this.cameraGlTextures = new int[1];
                    GLES20.glGenTextures((int)1, (int[])this.cameraGlTextures, (int)0);
                    GLES20.glBindTexture((int)36197, (int)this.cameraGlTextures[0]);
                    GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
                    GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
                    GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
                    GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
                    this.cameraSurfaceTexture = new SurfaceTexture(this.cameraGlTextures[0]);
                    this.cameraSurfaceTexture.setOnFrameAvailableListener(null);
                    this.camera.setPreviewTexture(this.cameraSurfaceTexture);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                throw new RuntimeException("No preview surface for Camera.");
            }
            Log.d((String)TAG, (String)("Camera orientation: " + this.info.orientation + ". Device orientation: " + this.getDeviceOrientation()));
            Camera.Parameters parameters = this.camera.getParameters();
            if (Build.VERSION.SDK_INT > 14) {
                Log.d((String)TAG, (String)("isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported()));
                if (parameters.isVideoStabilizationSupported()) {
                    parameters.setVideoStabilization(true);
                }
            }
            if ((list = parameters.getSupportedFocusModes()) != null && list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            }
            parameters.setPreviewSize(n, n2);
            List<int[]> list2 = VideoCaptureDeviceInfoAndroid.getFpsRangesRobust(parameters);
            this.frameDropRatio = Integer.MAX_VALUE;
            for (n6 = 0; n6 < list2.size(); ++n6) {
                int[] nArray = list2.get(n6);
                if (nArray[0] == n3 && nArray[1] == n4) {
                    this.frameDropRatio = 1;
                    break;
                }
                if (nArray[0] % n3 != 0 || nArray[1] % n4 != 0) continue;
                n5 = nArray[1] / n4;
                this.frameDropRatio = Math.min(n5, this.frameDropRatio);
            }
            if (this.frameDropRatio == Integer.MAX_VALUE) {
                Log.e((String)TAG, (String)"Can not find camera fps range");
                exception = new RuntimeException("Can not find camera fps range");
                VideoCaptureAndroid.exchange(exchanger, false);
                return;
            }
            if (this.frameDropRatio > 1) {
                Log.d((String)TAG, (String)("Frame dropper is enabled. Ratio: " + this.frameDropRatio));
            }
            Log.d((String)TAG, (String)("Camera preview mfps range: " + (n3 *= this.frameDropRatio) + " - " + (n4 *= this.frameDropRatio)));
            if (Build.VERSION.SDK_INT > 8) {
                parameters.setPreviewFpsRange(n3, n4);
            } else {
                parameters.setPreviewFrameRate(n4 / 1000);
            }
            n6 = 17;
            parameters.setPreviewFormat(n6);
            this.camera.setParameters(parameters);
            try {
                parameters.setPictureSize(n, n2);
                this.camera.setParameters(parameters);
            }
            catch (RuntimeException runtimeException) {
                Log.d((String)TAG, (String)"Failed to apply Nexus 7 workaround");
            }
            int n7 = n * n2 * ImageFormat.getBitsPerPixel((int)n6) / 8;
            for (n5 = 0; n5 < 3; ++n5) {
                this.camera.addCallbackBuffer(new byte[n7]);
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            this.frameCount = 0;
            this.averageDurationMs = 1000000.0f / (float)(n4 / this.frameDropRatio);
            this.camera.startPreview();
            this.mCaptureWidth = n;
            this.mCaptureHeight = n2;
            this.mCaptureMinFPS = n3;
            this.mCaptureMaxFPS = n4;
            if (!this.mResumeCapture) {
                GeckoAppShell.getGeckoInterface().addAppStateListener((GeckoAppShell.AppStateListener)this);
            }
            VideoCaptureAndroid.exchange(exchanger, true);
            return;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        Log.e((String)TAG, (String)"startCapture failed", (Throwable)exception);
        if (this.camera != null) {
            Exchanger<Boolean> exchanger2 = new Exchanger<Boolean>();
            this.stopCaptureOnCameraThread(exchanger2);
            VideoCaptureAndroid.exchange(exchanger2, false);
        }
        VideoCaptureAndroid.exchange(exchanger, false);
    }

    @WebRTCJNITarget
    private synchronized boolean stopCapture() {
        Log.d((String)TAG, (String)"stopCapture");
        if (this.cameraThreadHandler == null) {
            return true;
        }
        final Exchanger exchanger = new Exchanger();
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureAndroid.this.stopCaptureOnCameraThread(exchanger);
            }
        });
        boolean bl = VideoCaptureAndroid.exchange(exchanger, false);
        try {
            this.cameraThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        this.cameraThreadHandler = null;
        this.cameraThread = null;
        Log.d((String)TAG, (String)"stopCapture done");
        return bl;
    }

    @WebRTCJNITarget
    private void unlinkCapturer() {
        this.native_capturer = 0L;
    }

    private void stopCaptureOnCameraThread(Exchanger<Boolean> exchanger) {
        if (this.camera == null) {
            if (this.mResumeCapture) {
                this.mResumeCapture = false;
                return;
            }
            throw new RuntimeException("Camera is already stopped!");
        }
        Exception exception = null;
        try {
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.stopPreview();
            if (localPreview != null) {
                localPreview.removeCallback((SurfaceHolder.Callback)this);
                this.camera.setPreviewDisplay(null);
            } else if (Build.VERSION.SDK_INT > 10) {
                this.camera.setPreviewTexture(null);
                this.cameraSurfaceTexture = null;
                if (this.cameraGlTextures != null) {
                    GLES20.glDeleteTextures((int)1, (int[])this.cameraGlTextures, (int)0);
                    this.cameraGlTextures = null;
                }
            }
            this.camera.release();
            this.camera = null;
            if (!this.mResumeCapture) {
                GeckoAppShell.getGeckoInterface().removeAppStateListener((GeckoAppShell.AppStateListener)this);
                ViERenderer.DestroyLocalRenderer();
            }
            VideoCaptureAndroid.exchange(exchanger, true);
            Looper.myLooper().quit();
            return;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        Log.e((String)TAG, (String)"Failed to stop camera", (Throwable)exception);
        VideoCaptureAndroid.exchange(exchanger, false);
        Looper.myLooper().quit();
    }

    @WebRTCJNITarget
    private int getDeviceOrientation() {
        int n = 0;
        if (this.context != null) {
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            switch (windowManager.getDefaultDisplay().getRotation()) {
                case 1: {
                    n = 90;
                    break;
                }
                case 2: {
                    n = 180;
                    break;
                }
                case 3: {
                    n = 270;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    @WebRTCJNITarget
    private native void ProvideCameraFrame(byte[] var1, int var2, int var3, long var4, long var6);

    @WebRTCJNITarget
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (Thread.currentThread() != this.cameraThread) {
            throw new RuntimeException("Camera callback not on camera thread?!?");
        }
        if (this.camera == null) {
            return;
        }
        if (this.camera != camera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        ++this.frameCount;
        if (this.frameDropRatio > 1 && this.frameCount % this.frameDropRatio > 0) {
            this.camera.addCallbackBuffer(byArray);
            return;
        }
        long l = SystemClock.elapsedRealtime();
        if (this.frameCount > this.frameDropRatio) {
            double d = l - this.lastCaptureTimeMs;
            this.averageDurationMs = 0.9 * this.averageDurationMs + 0.1 * d;
            if (this.frameCount % 30 == 0) {
                Log.d((String)TAG, (String)("Camera TS " + l + ". Duration: " + (int)d + " ms. FPS: " + (int)(1000.0 / this.averageDurationMs + 0.5)));
            }
        }
        this.lastCaptureTimeMs = l;
        int n = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            n = 360 - n;
        }
        n = (this.info.orientation + n) % 360;
        if (byArray != null) {
            this.ProvideCameraFrame(byArray, byArray.length, this.mCaptureRotation, this.lastCaptureTimeMs, this.native_capturer);
            this.camera.addCallbackBuffer(byArray);
        }
    }

    @WebRTCJNITarget
    public synchronized void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.d((String)TAG, (String)("VideoCaptureAndroid::surfaceChanged ignored: " + n + ": " + n2 + "x" + n3));
    }

    @WebRTCJNITarget
    public synchronized void surfaceCreated(final SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceCreated");
        if (this.camera == null || this.cameraThreadHandler == null) {
            return;
        }
        final Exchanger exchanger = new Exchanger();
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureAndroid.this.setPreviewDisplayOnCameraThread(surfaceHolder, exchanger);
            }
        });
        IOException iOException = VideoCaptureAndroid.exchange(exchanger, null);
        if (iOException != null) {
            throw new RuntimeException(iOException);
        }
    }

    @WebRTCJNITarget
    public synchronized void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceDestroyed");
        if (this.camera == null || this.cameraThreadHandler == null) {
            return;
        }
        final Exchanger exchanger = new Exchanger();
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureAndroid.this.setPreviewDisplayOnCameraThread(null, exchanger);
            }
        });
        IOException iOException = VideoCaptureAndroid.exchange(exchanger, null);
        if (iOException != null) {
            throw new RuntimeException(iOException);
        }
    }

    private void setPreviewDisplayOnCameraThread(SurfaceHolder surfaceHolder, Exchanger<IOException> exchanger) {
        try {
            this.camera.setPreviewDisplay(surfaceHolder);
        }
        catch (IOException iOException) {
            VideoCaptureAndroid.exchange(exchanger, iOException);
            return;
        }
        VideoCaptureAndroid.exchange(exchanger, null);
    }

    private static <T> T exchange(Exchanger<T> exchanger, T t) {
        try {
            return exchanger.exchange(t);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private class CameraThread
    extends Thread {
        private Exchanger<Handler> handlerExchanger;

        public CameraThread(Exchanger<Handler> exchanger) {
            this.handlerExchanger = exchanger;
        }

        @Override
        public void run() {
            Looper.prepare();
            VideoCaptureAndroid.exchange(this.handlerExchanger, new Handler());
            Looper.loop();
        }
    }
}

