/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.app.Activity;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.WebRTCJNITarget;
import org.mozilla.gecko.permissions.Permissions;
import org.webrtc.videoengine.CaptureCapabilityAndroid;

public class VideoCaptureDeviceInfoAndroid {
    private static final String TAG = "WEBRTC-JC";

    private static boolean isFrontFacing(Camera.CameraInfo cameraInfo) {
        return cameraInfo.facing == 1;
    }

    private static String deviceUniqueName(int n, Camera.CameraInfo cameraInfo) {
        return "Camera " + n + ", Facing " + (VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo) ? "front" : "back") + ", Orientation " + cameraInfo.orientation;
    }

    @WebRTCJNITarget
    public static List<int[]> getFpsRangesRobust(Camera.Parameters parameters) {
        ArrayList<int[]> arrayList = null;
        if (Build.VERSION.SDK_INT >= 9) {
            arrayList = parameters.getSupportedPreviewFpsRange();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<int[]>();
            List list = parameters.getSupportedPreviewFrameRates();
            if (list != null) {
                for (Integer n : list) {
                    int[] nArray = new int[]{n * 1000, n * 1000};
                    arrayList.add(nArray);
                }
            } else {
                Log.e((String)TAG, (String)"Camera doesn't know its own framerate, guessing 30fps.");
                int[] nArray = new int[]{30000, 30000};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    @WebRTCJNITarget
    private static CaptureCapabilityAndroid[] getDeviceInfo() {
        boolean bl = Permissions.waitFor((Activity)((Activity)GeckoAppShell.getContext()), (String[])new String[]{"android.permission.CAMERA"});
        if (bl) {
            return VideoCaptureDeviceInfoAndroid.createDeviceList();
        }
        return new CaptureCapabilityAndroid[0];
    }

    private static CaptureCapabilityAndroid[] createDeviceList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 1;
        if (Build.VERSION.SDK_INT >= 9) {
            n = Camera.getNumberOfCameras();
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = null;
            Camera.CameraInfo cameraInfo = null;
            if (Build.VERSION.SDK_INT >= 9) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                string = VideoCaptureDeviceInfoAndroid.deviceUniqueName(i, cameraInfo);
            } else {
                string = "Camera 0, Facing back, Orientation 90";
            }
            List list = null;
            List<int[]> list2 = null;
            try {
                Camera camera = null;
                camera = Build.VERSION.SDK_INT >= 9 ? Camera.open((int)i) : Camera.open();
                Camera.Parameters parameters = camera.getParameters();
                list = parameters.getSupportedPreviewSizes();
                list2 = VideoCaptureDeviceInfoAndroid.getFpsRangesRobust(parameters);
                camera.release();
                Log.d((String)TAG, (String)string);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)TAG, (String)("Failed to open " + string + ", skipping due to: " + runtimeException.getLocalizedMessage()));
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (int[] nArray : list2) {
                if (nArray[0] == 30000 && nArray[1] == 30000) {
                    bl = true;
                }
                if (nArray[0] != 15000 || nArray[1] != 15000) continue;
                bl2 = true;
            }
            if (bl && !bl2) {
                Log.d((String)TAG, (String)"Adding 15 fps support");
                object = new int[2];
                object[0] = 15000;
                object[1] = 15000;
                list2.add((int[])object);
            }
            object = new CaptureCapabilityAndroid();
            int n2 = list.size();
            ((CaptureCapabilityAndroid)object).width = new int[n2];
            ((CaptureCapabilityAndroid)object).height = new int[n2];
            int n3 = 0;
            for (Camera.Size size : list) {
                ((CaptureCapabilityAndroid)object).width[n3] = size.width;
                ((CaptureCapabilityAndroid)object).height[n3] = size.height;
                ++n3;
            }
            Object object2 = list2.get(list2.size() - 1);
            ((CaptureCapabilityAndroid)object).name = string;
            if (Build.VERSION.SDK_INT >= 9) {
                ((CaptureCapabilityAndroid)object).frontFacing = VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo);
                ((CaptureCapabilityAndroid)object).orientation = cameraInfo.orientation;
                ((CaptureCapabilityAndroid)object).minMilliFPS = (int)object2[0];
                ((CaptureCapabilityAndroid)object).maxMilliFPS = (int)object2[1];
            } else {
                ((CaptureCapabilityAndroid)object).frontFacing = false;
                ((CaptureCapabilityAndroid)object).orientation = 90;
                ((CaptureCapabilityAndroid)object).minMilliFPS = (int)object2[0];
                ((CaptureCapabilityAndroid)object).maxMilliFPS = (int)object2[1];
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new CaptureCapabilityAndroid[0]);
    }
}

