/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import org.mozilla.gecko.annotation.WebRTCJNITarget;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@WebRTCJNITarget
class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int CHANNELS = 1;
    private final long nativeAudioManager;
    private final Context context;
    private final AudioManager audioManager;
    private boolean initialized = false;
    private int nativeSampleRate;
    private int nativeChannels;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn = false;

    WebRtcAudioManager(Context context, long l) {
        WebRtcAudioManager.Logd("ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioManager = l;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.nativeSampleRate, this.nativeChannels, l);
    }

    private boolean init() {
        WebRtcAudioManager.Logd("init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.audioManager.setMode(3);
        this.initialized = true;
        return true;
    }

    private void dispose() {
        WebRtcAudioManager.Logd("dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.audioManager.setMode(this.savedAudioMode);
    }

    private void storeAudioParameters() {
        String string;
        this.nativeChannels = 1;
        this.nativeSampleRate = !WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? 44100 : ((string = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) == null ? 44100 : Integer.parseInt(string));
        WebRtcAudioManager.Logd("nativeSampleRate: " + this.nativeSampleRate);
        WebRtcAudioManager.Logd("nativeChannels: " + this.nativeChannels);
    }

    private void setSpeakerphoneOn(boolean bl) {
        boolean bl2 = this.audioManager.isSpeakerphoneOn();
        if (bl2 == bl) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(bl);
    }

    private boolean hasEarpiece() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private static void Logd(String string) {
        Log.d((String)TAG, (String)string);
    }

    private static void Loge(String string) {
        Log.e((String)TAG, (String)string);
    }

    private native void nativeCacheAudioParameters(int var1, int var2, long var3);
}

