/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import org.mozilla.gecko.annotation.WebRTCJNITarget;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@WebRTCJNITarget
class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final long nativeAudioRecord;
    private final Context context;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord;
    private AudioRecordThread audioThread = null;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;

    WebRtcAudioRecord(Context context, long l) {
        WebRtcAudioRecord.Logd("ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = l;
    }

    public static boolean BuiltInAECIsAvailable() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) {
            return false;
        }
        return AcousticEchoCanceler.isAvailable();
    }

    private boolean EnableBuiltInAEC(boolean bl) {
        WebRtcAudioRecord.Logd("EnableBuiltInAEC(" + bl + ')');
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) {
            return false;
        }
        this.useBuiltInAEC = bl;
        if (this.aec != null) {
            int n = this.aec.setEnabled(bl);
            if (n != 0) {
                WebRtcAudioRecord.Loge("AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            WebRtcAudioRecord.Logd("AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private int InitRecording(int n, int n2) {
        WebRtcAudioRecord.Logd("InitRecording(sampleRate=" + n + ", channels=" + n2 + ")");
        int n3 = n2 * 2;
        int n4 = n / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * n4);
        WebRtcAudioRecord.Logd("byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int n5 = AudioRecord.getMinBufferSize((int)n, (int)16, (int)2);
        WebRtcAudioRecord.Logd("AudioRecord.getMinBufferSize: " + n5);
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        WebRtcAudioRecord.assertTrue(this.audioRecord == null);
        int n6 = Math.max(this.byteBuffer.capacity(), n5);
        WebRtcAudioRecord.Logd("bufferSizeInBytes: " + n6);
        int n7 = 7;
        if (Build.VERSION.SDK_INT < 11) {
            n7 = 0;
        }
        try {
            this.audioRecord = new AudioRecord(n7, n, 16, 2, n6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WebRtcAudioRecord.Logd(illegalArgumentException.getMessage());
            return -1;
        }
        WebRtcAudioRecord.assertTrue(this.audioRecord.getState() == 1);
        WebRtcAudioRecord.Logd("AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", " + "audio format: " + this.audioRecord.getAudioFormat() + ", " + "channels: " + this.audioRecord.getChannelCount() + ", " + "sample rate: " + this.audioRecord.getSampleRate());
        WebRtcAudioRecord.Logd("AcousticEchoCanceler.isAvailable: " + WebRtcAudioRecord.BuiltInAECIsAvailable());
        if (!WebRtcAudioRecord.BuiltInAECIsAvailable()) {
            return n4;
        }
        this.aec = AcousticEchoCanceler.create((int)this.audioRecord.getAudioSessionId());
        if (this.aec == null) {
            WebRtcAudioRecord.Loge("AcousticEchoCanceler.create failed");
            return -1;
        }
        int n8 = this.aec.setEnabled(this.useBuiltInAEC);
        if (n8 != 0) {
            WebRtcAudioRecord.Loge("AcousticEchoCanceler.setEnabled failed");
            return -1;
        }
        AudioEffect.Descriptor descriptor = this.aec.getDescriptor();
        WebRtcAudioRecord.Logd("AcousticEchoCanceler name: " + descriptor.name + ", " + "implementor: " + descriptor.implementor + ", " + "uuid: " + descriptor.uuid);
        WebRtcAudioRecord.Logd("AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        return n4;
    }

    private boolean StartRecording() {
        WebRtcAudioRecord.Logd("StartRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean StopRecording() {
        WebRtcAudioRecord.Logd("StopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        this.audioRecord.release();
        this.audioRecord = null;
        return true;
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private static void Logd(String string) {
        Log.d((String)TAG, (String)string);
    }

    private static void Loge(String string) {
        Log.e((String)TAG, (String)string);
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            WebRtcAudioRecord.Logd("AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            try {
                WebRtcAudioRecord.this.audioRecord.startRecording();
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioRecord.Loge("AudioRecord.startRecording failed: " + illegalStateException.getMessage());
                return;
            }
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long l = System.nanoTime();
            while (this.keepAlive) {
                int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    WebRtcAudioRecord.this.nativeDataIsRecorded(n, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                WebRtcAudioRecord.Loge("AudioRecord.read failed: " + n);
                if (n != -3) continue;
                this.keepAlive = false;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioRecord.Loge("AudioRecord.stop failed: " + illegalStateException.getMessage());
            }
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

