/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa;

import android.accounts.Account;
import android.content.AsyncTaskLoader;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.fxa.FirefoxAccounts;

public class AccountLoader
extends AsyncTaskLoader<Account> {
    protected Account account = null;
    protected BroadcastReceiver broadcastReceiver = null;
    private final BroadcastReceiverRunnable broadcastReceiverRunnable = new BroadcastReceiverRunnable(this);

    public AccountLoader(Context context) {
        super(context);
    }

    public Account loadInBackground() {
        return FirefoxAccounts.getFirefoxAccount(this.getContext());
    }

    public void deliverResult(Account account) {
        if (this.isReset()) {
            this.releaseResources(account);
            return;
        }
        Account account2 = this.account;
        this.account = account;
        if (this.isStarted()) {
            super.deliverResult((Object)account);
        }
        if (account2 != null && account2 != account) {
            this.releaseResources(account2);
        }
    }

    protected void onStartLoading() {
        if (this.account != null) {
            this.deliverResult(this.account);
        }
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = this.makeNewObserver();
            AccountLoader.registerLocalObserver(this.getContext(), this.broadcastReceiver);
            AccountLoader.registerSystemObserver(this.getContext(), this.broadcastReceiver);
        }
        if (this.takeContentChanged() || this.account == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.stopLoading();
        if (this.account != null) {
            this.releaseResources(this.account);
            this.account = null;
        }
        if (this.broadcastReceiver != null) {
            BroadcastReceiver broadcastReceiver = this.broadcastReceiver;
            this.broadcastReceiver = null;
            AccountLoader.unregisterObserver(this.getContext(), broadcastReceiver);
        }
    }

    public void onCanceled(Account account) {
        super.onCanceled((Object)account);
        this.releaseResources(account);
    }

    protected BroadcastReceiver makeNewObserver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    AccountLoader.this.onContentChanged();
                    return;
                }
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post((Runnable)AccountLoader.this.broadcastReceiverRunnable);
            }
        };
    }

    private void releaseResources(Account account) {
    }

    protected static void registerLocalObserver(Context context, BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_STATE_CHANGED_ACTION");
        intentFilter.addAction("org.mozilla.gecko.fxa.profile.JSON.updated");
        LocalBroadcastManager.getInstance((Context)context).registerReceiver(broadcastReceiver, intentFilter);
    }

    protected static void registerSystemObserver(Context context, BroadcastReceiver broadcastReceiver) {
        context.registerReceiver(broadcastReceiver, new IntentFilter("android.accounts.LOGIN_ACCOUNTS_CHANGED"), null, null);
    }

    protected static void unregisterObserver(Context context, BroadcastReceiver broadcastReceiver) {
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver(broadcastReceiver);
        context.unregisterReceiver(broadcastReceiver);
    }

    private static class BroadcastReceiverRunnable
    implements Runnable {
        private final WeakReference<AccountLoader> accountLoaderWeakReference;

        public BroadcastReceiverRunnable(AccountLoader accountLoader) {
            this.accountLoaderWeakReference = new WeakReference<AccountLoader>(accountLoader);
        }

        @Override
        public void run() {
            AccountLoader accountLoader = (AccountLoader)((Object)this.accountLoaderWeakReference.get());
            if (accountLoader != null) {
                accountLoader.onContentChanged();
            }
        }
    }
}

