/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.delegates;

import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class DeferredRepositorySessionFetchRecordsDelegate
implements RepositorySessionFetchRecordsDelegate {
    private final RepositorySessionFetchRecordsDelegate inner;
    private final ExecutorService executor;

    public DeferredRepositorySessionFetchRecordsDelegate(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate, ExecutorService executorService) {
        this.inner = repositorySessionFetchRecordsDelegate;
        this.executor = executorService;
    }

    @Override
    public void onFetchedRecord(final Record record) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionFetchRecordsDelegate.this.inner.onFetchedRecord(record);
            }
        });
    }

    @Override
    public void onFetchFailed(final Exception exception, final Record record) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionFetchRecordsDelegate.this.inner.onFetchFailed(exception, record);
            }
        });
    }

    @Override
    public void onFetchCompleted(final long l) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionFetchRecordsDelegate.this.inner.onFetchCompleted(l);
            }
        });
    }

    @Override
    public RepositorySessionFetchRecordsDelegate deferredFetchDelegate(ExecutorService executorService) {
        if (executorService == this.executor) {
            return this;
        }
        throw new IllegalArgumentException("Can't re-defer this delegate.");
    }
}

