/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebURLFinder {
    public static final String GOOD_IRI_CHAR = "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    public static final String GOOD_GTLD_CHAR = "a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    public static final String IRI = "[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}";
    public static final String GTLD = "[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    public static final String HOST_NAME = "([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    public static final Pattern IP_ADDRESS = Pattern.compile("((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9]))");
    public static final Pattern DOMAIN_NAME = Pattern.compile("(([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}|" + IP_ADDRESS + ")");
    public static final Pattern WEB_URL = Pattern.compile("((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?(?:" + DOMAIN_NAME + ")" + "(?:\\:\\d{1,5})?)" + "(\\/(?:(?:[" + "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef" + "\\;\\/\\?\\:\\@\\&\\=\\#\\~" + "\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?" + "(?:\\b|$)");
    public final List<String> candidates;

    public WebURLFinder(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(string);
    }

    public WebURLFinder(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(list);
    }

    public static boolean isWebURL(String string) {
        try {
            new URI(string);
        }
        catch (Exception exception) {
            return false;
        }
        return !URLUtil.isFileUrl((String)string) && !URLUtil.isJavaScriptUrl((String)string);
    }

    public String bestWebURL() {
        String string = this.firstWebURLWithScheme();
        if (string != null) {
            return string;
        }
        return this.firstWebURLWithoutScheme();
    }

    protected static List<String> candidateWebURLs(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (string == null) continue;
            arrayList.addAll(WebURLFinder.candidateWebURLs(string));
        }
        return arrayList;
    }

    protected static List<String> candidateWebURLs(String string) {
        Matcher matcher = WEB_URL.matcher(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            if (!WebURLFinder.isWebURL(matcher.group()) || matcher.start() > 0 && string.charAt(matcher.start() - 1) == '@') continue;
            linkedList.add(matcher.group());
        }
        return linkedList;
    }

    protected String firstWebURLWithScheme() {
        for (String string : this.candidates) {
            try {
                if (new URI(string).getScheme() == null) continue;
                return string;
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    protected String firstWebURLWithoutScheme() {
        if (!this.candidates.isEmpty()) {
            return this.candidates.get(0);
        }
        return null;
    }
}

