/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.RemoteViews;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;

public class SearchWidget
extends AppWidgetProvider {
    private static final String LOGTAG = "GeckoSearchWidget";
    public static final String ACTION_LAUNCH_BROWSER = "org.mozilla.widget.LAUNCH_BROWSER";
    public static final String ACTION_LAUNCH_SEARCH = "org.mozilla.widget.LAUNCH_SEARCH";
    public static final String ACTION_LAUNCH_NEW_TAB = "org.mozilla.widget.LAUNCH_NEW_TAB";

    @TargetApi(value=16)
    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] nArray) {
        for (int n : nArray) {
            Bundle bundle = AppConstants.Versions.feature16Plus ? appWidgetManager.getAppWidgetOptions(n) : null;
            this.addView(appWidgetManager, context, n, bundle);
        }
        super.onUpdate(context, appWidgetManager, nArray);
    }

    @TargetApi(value=16)
    public void onAppWidgetOptionsChanged(Context context, AppWidgetManager appWidgetManager, int n, Bundle bundle) {
        this.addView(appWidgetManager, context, n, bundle);
        if (AppConstants.Versions.feature16Plus) {
            super.onAppWidgetOptionsChanged(context, appWidgetManager, n, bundle);
        }
    }

    public void onReceive(Context context, Intent intent) {
        Intent intent2;
        switch (intent.getAction()) {
            case "org.mozilla.widget.LAUNCH_BROWSER": {
                intent2 = this.buildRedirectIntent("android.intent.action.MAIN", context.getPackageName(), "org.mozilla.gecko.BrowserApp", intent);
                Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.LAUNCH, (TelemetryContract.Method)TelemetryContract.Method.WIDGET, (String)"browser");
                break;
            }
            case "org.mozilla.widget.LAUNCH_NEW_TAB": {
                intent2 = this.buildRedirectIntent("android.intent.action.VIEW", context.getPackageName(), "org.mozilla.gecko.BrowserApp", intent);
                Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.LAUNCH, (TelemetryContract.Method)TelemetryContract.Method.WIDGET, (String)"new-tab");
                break;
            }
            case "org.mozilla.widget.LAUNCH_SEARCH": {
                intent2 = this.buildRedirectIntent("android.intent.action.VIEW", context.getPackageName(), "org.mozilla.search.SearchActivity", intent);
                Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.LAUNCH, (TelemetryContract.Method)TelemetryContract.Method.WIDGET, (String)"search");
                break;
            }
            default: {
                intent2 = null;
            }
        }
        if (intent2 != null) {
            context.startActivity(intent2);
        }
        super.onReceive(context, intent);
    }

    private void addView(AppWidgetManager appWidgetManager, Context context, int n, Bundle bundle) {
        RemoteViews remoteViews = new RemoteViews(context.getPackageName(), R.layout.search_widget);
        this.addClickIntent(context, remoteViews, R.id.search_button, ACTION_LAUNCH_SEARCH);
        this.addClickIntent(context, remoteViews, R.id.new_tab_button, ACTION_LAUNCH_NEW_TAB);
        this.addClickIntent(context, remoteViews, R.id.logo_button, ACTION_LAUNCH_BROWSER);
        appWidgetManager.updateAppWidget(n, remoteViews);
    }

    private void addClickIntent(Context context, RemoteViews remoteViews, int n, String string2) {
        Intent intent = new Intent(context, SearchWidget.class);
        intent.setAction(string2);
        intent.setData(Uri.parse((String)"about:home"));
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        remoteViews.setOnClickPendingIntent(n, pendingIntent);
    }

    private Intent buildRedirectIntent(String string2, String string3, String string4, Intent intent) {
        Intent intent2 = new Intent(string2);
        if (string3 != null && string4 != null) {
            intent2.setClassName(string3, string4);
        }
        intent2.setData(intent.getData());
        intent2.addFlags(0x10000000);
        return intent2;
    }
}

