// |reftest| skip -- has YAML errors
// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
description:
    Ambiguous exports are not reflected in module namespace objects, nor do
    they trigger an error upon resolution
esid: sec-moduledeclarationinstantiation
info: |
    [...]
    12. For each ImportEntry Record in in module.[[ImportEntries]], do
        a. Let importedModule be ? HostResolveImportedModule(module,
           in.[[ModuleRequest]]).
        b. If in.[[ImportName]] is "*", then
           i. Let namespace be ? GetModuleNamespace(importedModule).
    [...]

    15.2.1.18 Runtime Semantics: GetModuleNamespace

    [...]
    3. If namespace is undefined, then
       [...]
       c. For each name that is an element of exportedNames,
          i. Let resolution be ? module.ResolveExport(name, « », « »).
          ii. If resolution is null, throw a SyntaxError exception.
          iii. If resolution is not "ambiguous", append name to
               unambiguousNames.
       d. Let namespace be ModuleNamespaceCreate(module, unambiguousNames).
flags: [module]
---*/

import * as ns from './instn-star-ambiguous_FIXTURE.js';

assert('first' in ns, 'Non-ambiguous exports from first module are present');
assert('second' in ns, 'Non-ambiguous exports from second module are present');
assert.sameValue('both' in ns, false, 'Ambiguous export is not present');

reportCompare(0, 0);
