// Copyright (C) 2015 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 23.3.3.2
description: >
  Throws TypeError if `this` doesn't have a [[WeakMapData]] internal slot.
info: >
  WeakMap.prototype.delete ( value )

  ...
  3. If M does not have a [[WeakMapData]] internal slot, throw a TypeError
  exception.
  ...
features: [Map]
---*/

assert.throws(TypeError, function() {
  WeakMap.prototype.delete.call(new Map(), {});
});

assert.throws(TypeError, function() {
  var map = new WeakMap();
  map.delete.call(new Map(), {});
});

reportCompare(0, 0);
