var browserTests = [
["foo[]bar",
    [["underline",""]],
    "foo[]bar",
    [true],
    {"underline":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["underline",""]],
    "<p><span style=\"text-decoration:underline\">[foo</span></p> <p><span style=\"text-decoration:underline\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["underline",""]],
    "<p><u>[foo</u></p> <p><u>bar]</u></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["underline",""]],
    "<u><span>[foo</span> <span>bar]</span></u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["underline",""]],
    "<p><span style=\"text-decoration:underline\">[foo</span></p><p> <span style=\"text-decoration:underline\"><span>bar</span></span> </p><p><span style=\"text-decoration:underline\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["underline",""]],
    "<p><u>[foo</u></p><p> <u><span>bar</span></u> </p><p><u>baz]</u></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["underline",""]],
    "<p><span style=\"text-decoration:underline\">[foo</span></p><p><span style=\"text-decoration:underline\"><br></span></p><p><span style=\"text-decoration:underline\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["underline",""]],
    "<p><u>[foo</u></p><p><u><br></u></p><p><u>bar]</u></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
    [["underline",""]],
    "<b>foo[]bar</b>",
    [true],
    {"underline":[false,false,"",false,true,""]}],
["<i>foo[]bar</i>",
    [["underline",""]],
    "<i>foo[]bar</i>",
    [true],
    {"underline":[false,false,"",false,true,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["underline",""]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"underline":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
    [["underline",""]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"underline":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u>[bar]</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\">[bar</span><b><span style=\"text-decoration:underline\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u>[bar</u><b><u>baz]</u>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\">[bar</span><i><span style=\"text-decoration:underline\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u>[bar</u><i><u>baz]</u>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["underline",""]],
    "{<p></p><p> </p><p><span style=\"text-decoration:underline\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["underline",""]],
    "{<p></p><p> </p><p><u>foo</u></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["underline",""]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"text-decoration:underline\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["underline",""]],
    "<table><tbody><tr><td>foo</td><td>b<u>[a]</u>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["underline",""]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"text-decoration:underline\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["underline",""]],
    "<table><tbody><tr><td>foo</td>{<td><u>bar</u></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["underline",""]],
    "<table><tbody><tr>{<td><span style=\"text-decoration:underline\">foo</span></td><td><span style=\"text-decoration:underline\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["underline",""]],
    "<table><tbody><tr>{<td><u>foo</u></td><td><u>bar</u></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["underline",""]],
    "<table><tbody>{<tr><td><span style=\"text-decoration:underline\">foo</span></td><td><span style=\"text-decoration:underline\">bar</span></td><td><span style=\"text-decoration:underline\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["underline",""]],
    "<table><tbody>{<tr><td><u>foo</u></td><td><u>bar</u></td><td><u>baz</u></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["underline",""]],
    "<table>{<tbody><tr><td><span style=\"text-decoration:underline\">foo</span></td><td><span style=\"text-decoration:underline\">bar</span></td><td><span style=\"text-decoration:underline\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["underline",""]],
    "<table>{<tbody><tr><td><u>foo</u></td><td><u>bar</u></td><td><u>baz</u></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["underline",""]],
    "{<table><tbody><tr><td><span style=\"text-decoration:underline\">foo</span></td><td><span style=\"text-decoration:underline\">bar</span></td><td><span style=\"text-decoration:underline\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["underline",""]],
    "{<table><tbody><tr><td><u>foo</u></td><td><u>bar</u></td><td><u>baz</u></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">foo</span>[bar]<span style=\"text-decoration:underline\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","false"],["underline",""]],
    "<u>foo</u>[bar]<u>baz</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\">ar]<span style=\"text-decoration:underline\">ba</span></span><span style=\"text-decoration:underline\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["underline",""]],
    "<u>foo</u>[b<span style=\"color:rgb(0, 0, 255)\">ar]<u>ba</u></span><u>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<span style=\"text-decoration:underline\">ba</span></span><span style=\"text-decoration:underline\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","false"],["underline",""]],
    "<u>foo</u>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<u>ba</u></span><u>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">foo</span>[b<span style=\"font-size:3em\">ar]<span style=\"text-decoration:underline\">ba</span></span><span style=\"text-decoration:underline\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["underline",""]],
    "<u>foo</u>[b<span style=\"font-size:3em\">ar]<u>ba</u></span><u>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">foo</span>[b<i>ar]<span style=\"text-decoration:underline\">ba</span></i><span style=\"text-decoration:underline\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","false"],["underline",""]],
    "<u>foo</u>[b<i>ar]<u>ba</u></i><u>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["underline",""]],
    "<p><span style=\"text-decoration:underline\">foo</span>[bar]<span style=\"text-decoration:underline\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["underline",""]],
    "<p><u>foo</u>[bar]<u>baz</u></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><s>[bar]</s></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><s>[bar]</s></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><span style=\"text-decoration:line-through\">[bar]</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><span style=\"text-decoration:line-through\">[bar]</span></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[bar]baz</s>",
    [["stylewithcss","true"],["underline",""]],
    "<s>foo<span style=\"text-decoration:underline\">[bar]</span>baz</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[bar]baz</s>",
    [["stylewithcss","false"],["underline",""]],
    "<s>foo<u>[bar]</u>baz</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["underline",""]],
    "<s>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["underline",""]],
    "<s>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\"><u>ar]</u>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","true"],["underline",""]],
    "<s>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","false"],["underline",""]],
    "<s>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><u>ar]</u>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["underline",""]],
    "<s>foo<span style=\"text-decoration:underline\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["underline",""]],
    "<s>foo<u>[b</u><span style=\"font-size:3em\"><u>ar]</u>ba</span>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","true"],["underline",""]],
    "<s>foo<span style=\"text-decoration:underline\">[b</span><i><span style=\"text-decoration:underline\">ar]</span>ba</i>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","false"],["underline",""]],
    "<s>foo<u>[b</u><i><u>ar]</u>ba</i>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","true"],["underline",""]],
    "<p style=\"text-decoration:line-through\">foo<span style=\"text-decoration:underline\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","false"],["underline",""]],
    "<p style=\"text-decoration:line-through\">foo<u>[bar]</u>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><strike>[bar]</strike></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><strike>[bar]</strike></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","true"],["underline",""]],
    "<strike>foo<span style=\"text-decoration:underline\">[bar]</span>baz</strike>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","false"],["underline",""]],
    "<strike>foo<u>[bar]</u>baz</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["underline",""]],
    "<strike>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["underline",""]],
    "<strike>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\"><u>ar]</u>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","true"],["underline",""]],
    "<strike>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","false"],["underline",""]],
    "<strike>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><u>ar]</u>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["underline",""]],
    "<strike>foo<span style=\"text-decoration:underline\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["underline",""]],
    "<strike>foo<u>[b</u><span style=\"font-size:3em\"><u>ar]</u>ba</span>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","true"],["underline",""]],
    "<strike>foo<span style=\"text-decoration:underline\">[b</span><i><span style=\"text-decoration:underline\">ar]</span>ba</i>z</strike>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","false"],["underline",""]],
    "<strike>foo<u>[b</u><i><u>ar]</u>ba</i>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<ins>[bar]</ins>baz",
    [["underline",""]],
    "foo<ins>[bar]</ins>baz",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["<ins>foo[bar]baz</ins>",
    [["underline",""]],
    "<ins>foo[bar]baz</ins>",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\">ar]ba</span>z</ins>",
    [["underline",""]],
    "<ins>foo[b<span style=\"color:rgb(0, 0, 255)\">ar]ba</span>z</ins>",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</ins>",
    [["underline",""]],
    "<ins>foo[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]ba</span>z</ins>",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [["underline",""]],
    "<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["<ins>foo[b<i>ar]ba</i>z</ins>",
    [["underline",""]],
    "<ins>foo[b<i>ar]ba</i>z</ins>",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["foo<del>[bar]</del>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><del>[bar]</del></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<del>[bar]</del>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><del>[bar]</del></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[bar]baz</del>",
    [["stylewithcss","true"],["underline",""]],
    "<del>foo<span style=\"text-decoration:underline\">[bar]</span>baz</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[bar]baz</del>",
    [["stylewithcss","false"],["underline",""]],
    "<del>foo<u>[bar]</u>baz</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\">ar]ba</span>z</del>",
    [["stylewithcss","true"],["underline",""]],
    "<del>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\">ar]ba</span>z</del>",
    [["stylewithcss","false"],["underline",""]],
    "<del>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\"><u>ar]</u>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</del>",
    [["stylewithcss","true"],["underline",""]],
    "<del>foo<span style=\"text-decoration:underline\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</del>",
    [["stylewithcss","false"],["underline",""]],
    "<del>foo<u>[b</u><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><u>ar]</u>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [["stylewithcss","true"],["underline",""]],
    "<del>foo<span style=\"text-decoration:underline\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:underline\">ar]</span>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [["stylewithcss","false"],["underline",""]],
    "<del>foo<u>[b</u><span style=\"font-size:3em\"><u>ar]</u>ba</span>z</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<i>ar]ba</i>z</del>",
    [["stylewithcss","true"],["underline",""]],
    "<del>foo<span style=\"text-decoration:underline\">[b</span><i><span style=\"text-decoration:underline\">ar]</span>ba</i>z</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<del>foo[b<i>ar]ba</i>z</del>",
    [["stylewithcss","false"],["underline",""]],
    "<del>foo<u>[b</u><i><u>ar]</u>ba</i>z</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: underline line-through\">[bar]</span>baz",
    [["underline",""]],
    "foo<span style=\"text-decoration:line-through\">[bar]</span>baz",
    [true],
    {"underline":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:line-through\"><span style=\"text-decoration:underline\">b</span>[a]<span style=\"text-decoration:underline\">r</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<span style=\"text-decoration:line-through\"><u>b</u>[a]<u>r</u></span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\">b</span>[a]<span style=\"text-decoration:underline\">r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u>b</u>[a]<u>r</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><u style=\"text-decoration:line-through\">[bar]</u></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><u style=\"text-decoration:line-through\">[bar]</u></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<u style=\"text-decoration:line-through\">b<span style=\"text-decoration:underline\">[a]</span>r</u>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u style=\"text-decoration:line-through\">b<u>[a]</u>r</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><s style=\"text-decoration:overline\">[bar]</s></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><s style=\"text-decoration:overline\">[bar]</s></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<s style=\"text-decoration:overline\">b<span style=\"text-decoration:underline\">[a]</span>r</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<s style=\"text-decoration:overline\">b<u>[a]</u>r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><u style=\"text-decoration:overline\">[bar]</u></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><u style=\"text-decoration:overline\">[bar]</u></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<u style=\"text-decoration:overline\">b<span style=\"text-decoration:underline\">[a]</span>r</u>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u style=\"text-decoration:overline\">b<u>[a]</u>r</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["underline",""]],
    "<p style=\"text-decoration:overline\">foo<span style=\"text-decoration:underline\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["underline",""]],
    "<p style=\"text-decoration:overline\">foo<u>[bar]</u>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">[bar]</span>baz",
    [["underline",""]],
    "foo<span class=\"underline\">[bar]</span>baz",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["foo<span class=\"underline\">b[a]r</span>baz",
    [["underline",""]],
    "foo<span class=\"underline\">b[a]r</span>baz",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["foo<span class=\"line-through\">[bar]</span>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\"><span class=\"line-through\">[bar]</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<span class=\"line-through\">[bar]</span>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u><span class=\"line-through\">[bar]</span></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span class=\"line-through\">b[a]r</span>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span class=\"line-through\">b<span style=\"text-decoration:underline\">[a]</span>r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,false,"",false,true,""]}],
["foo<span class=\"line-through\">b[a]r</span>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<span class=\"line-through\">b<u>[a]</u>r</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,false,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [["underline",""]],
    "foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [["underline",""]],
    "foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [true],
    {"underline":[false,true,"",false,true,""]}],
["fo[o<u>b]ar</u>baz",
    [["underline",""]],
    "fo<u>[ob]ar</u>baz",
    [true],
    {"underline":[true,false,"",false,true,""]}],
["foo<u>ba[r</u>b]az",
    [["underline",""]],
    "foo<u>ba[rb]</u>az",
    [true],
    {"underline":[true,false,"",false,true,""]}],
["fo[o<u>bar</u>b]az",
    [["stylewithcss","true"],["underline",""]],
    "fo<span style=\"text-decoration:underline\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[true,false,"",false,true,""]}],
["fo[o<u>bar</u>b]az",
    [["stylewithcss","false"],["underline",""]],
    "fo<u>[obarb]</u>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[true,false,"",false,true,""]}],
["foo[<u>b]ar</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo[b]<span style=\"text-decoration:underline\">ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo[<u>b]ar</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo[b]<u>ar</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<u>ba[r</u>]baz",
    [["stylewithcss","true"],["underline",""]],
    "foo<span style=\"text-decoration:underline\">ba</span>[r]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<u>ba[r</u>]baz",
    [["stylewithcss","false"],["underline",""]],
    "foo<u>ba</u>[r]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo[<u>bar</u>]baz",
    [["stylewithcss","true"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo[<u>bar</u>]baz",
    [["stylewithcss","false"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo<u>[bar]</u>baz",
    [["stylewithcss","true"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo<u>[bar]</u>baz",
    [["stylewithcss","false"],["underline",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["foo{<u>bar</u>}baz",
    [["stylewithcss","true"],["underline",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",false,false,""]}],
["foo{<u>bar</u>}baz",
    [["stylewithcss","false"],["underline",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",false,false,""]}],
["fo[o<span style=text-decoration:underline>b]ar</span>baz",
    [["underline",""]],
    "fo<span style=\"text-decoration:underline\">[ob]ar</span>baz",
    [true],
    {"underline":[true,false,"",false,true,""]}],
["<ins>fo[o</ins><u>b]ar</u>",
    [["stylewithcss","true"],["underline",""]],
    "<ins>fo[o</ins>b]<span style=\"text-decoration:underline\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",true,false,""]}],
["<ins>fo[o</ins><u>b]ar</u>",
    [["stylewithcss","false"],["underline",""]],
    "<ins>fo[o</ins>b]<u>ar</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",true,false,""]}],
["<u>fo[o</u><ins>b]ar</ins>",
    [["stylewithcss","true"],["underline",""]],
    "<span style=\"text-decoration:underline\">fo</span>[o<ins>b]ar</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"underline":[false,true,"",true,false,""]}],
["<u>fo[o</u><ins>b]ar</ins>",
    [["stylewithcss","false"],["underline",""]],
    "<u>fo</u>[o<ins>b]ar</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"underline":[false,true,"",true,false,""]}]
]
