// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-arraybuffer.prototype.slice
es6id: 24.1.4.3
description: >
  ArrayBuffer.prototype.slice.length is 2.
info: >
  ArrayBuffer.prototype.slice ( start, end )

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, has a length
    property whose value is an integer. Unless otherwise specified, this
    value is equal to the largest number of named arguments shown in the
    subclause headings for the function description, including optional
    parameters. However, rest parameters shown using the form “...name”
    are not included in the default argument count.

    Unless otherwise specified, the length property of a built-in Function
    object has the attributes { [[Writable]]: false, [[Enumerable]]: false,
    [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(ArrayBuffer.prototype.slice.length, 2);

verifyNotEnumerable(ArrayBuffer.prototype.slice, "length");
verifyNotWritable(ArrayBuffer.prototype.slice, "length");
verifyConfigurable(ArrayBuffer.prototype.slice, "length");

reportCompare(0, 0);
