/* -*- indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */


/**
 *  File Name:          exception-007
 *  ECMA Section:
 *  Description:        Tests for JavaScript Standard Exceptions
 *
 *  DefaultValue error.
 *
 *  Author:             christine@netscape.com
 *  Date:               31 August 1998
 */
var SECTION = "exception-007";
var TITLE   = "Tests for JavaScript Standard Exceptions:  TypeError";
var BUGNUMBER="318250";

printBugNumber(BUGNUMBER);
writeHeaderToLog( SECTION + " "+ TITLE);

DefaultValue_1();

test();


/**
 * Getting the [[DefaultValue]] of any instances of MyObject
 * should result in a runtime error in ToPrimitive.
 */

function MyObject() {
  this.toString = void 0;
  this.valueOf = new Object();
}

function DefaultValue_1() {
  result = "failed: no exception thrown";
  exception = null;

  try {
    result = new MyObject() + new MyObject();
  } catch ( e ) {
    result = "passed:  threw exception",
      exception = e.toString();
  } finally {
    new TestCase(
      "new MyObject() + new MyObject() [ exception is " + exception +" ]",
      "passed:  threw exception",
      result );
  }
}

