// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-date.now
es6id: 20.3.3.1
description: >
  Date.now.name is "now".
info: >
  Date.now ( )

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(Date.now.name, "now");

verifyNotEnumerable(Date.now, "name");
verifyNotWritable(Date.now, "name");
verifyConfigurable(Date.now, "name");

reportCompare(0, 0);
