// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.map
es5id: 15.4.4.19-9-11
description: >
    Array.prototype.map - returns an empty array if 'length' is 0
    (subclassed Array, length overridden with obj w/o valueOf
    (toString))
---*/

        function Foo() { }
        Foo.prototype = [1, 2, 3];

        var f = new Foo();

        var o = {
            toString: function () {
                return '0';
            }
        };
        f.length = o;

        // objects inherit the default valueOf method of the Object object;
        // that simply returns the itself. Since the default valueOf() method
        // does not return a primitive value, ES next tries to convert the object
        // to a number by calling its toString() method and converting the
        // resulting string to a number.

        function cb() { }
        var a = Array.prototype.map.call(f, cb);

assert(Array.isArray(a), 'Array.isArray(a) !== true');
assert.sameValue(a.length, 0, 'a.length');

reportCompare(0, 0);
