# Shared/common mozharness configuration for Android unit tests.
#
# This configuration should be combined with platform-specific mozharness
# configuration such as androidarm_4_3.py, or similar.

import os


def WebglSuite(name):
    return {
        "run_filename": "runtestsremote.py",
        "testsdir": "mochitest",
        "options": [
            "--app=%(app)s",
            "--remote-webserver=%(remote_webserver)s",
            "--xre-path=%(xre_path)s",
            "--utility-path=%(utility_path)s",
            "--http-port=%(http_port)s",
            "--ssl-port=%(ssl_port)s",
            "--certificate-path=%(certs_path)s",
            "--symbols-path=%(symbols_path)s",
            "--quiet",
            "--log-raw=%(raw_log_file)s",
            "--log-raw-level=%(log_raw_level)s",
            "--log-errorsummary=%(error_summary_file)s",
            "--log-tbpl-level=%(log_tbpl_level)s",
            "--screenshot-on-fail",
            "--subsuite=" + name,
            "--deviceSerial=%(device_serial)s",
        ],
    }


config = {
    "default_actions": [
        'clobber',
        'setup-avds',
        'start-emulator',
        'download-and-extract',
        'create-virtualenv',
        'verify-device',
        'install',
        'run-tests',
    ],
    "tooltool_cache": os.environ.get("TOOLTOOL_CACHE"),
    "tooltool_servers": ['http://relengapi/tooltool/'],
    "hostutils_manifest_path": "testing/config/tooltool-manifests/linux64/hostutils.manifest",
    "avds_dir": "/builds/worker/workspace/build/.android",
    # "log_format": "%(levelname)8s - %(message)s",
    "log_tbpl_level": "info",
    "log_raw_level": "info",
    "minidump_stackwalk_path": "linux64-minidump_stackwalk",
    "marionette_address": "localhost:2828",
    "marionette_test_manifest": "unit-tests.ini",
    # To take device screenshots at timed intervals (each time in seconds, relative
    # to the start of the run-tests step) specify screenshot_times. For example, to
    # take 4 screenshots at one minute intervals you could specify:
    # "screenshot_times": [60, 120, 180, 240],

    "suite_definitions": {
        "mochitest-plain": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--screenshot-on-fail",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-webgl1-core": WebglSuite("webgl1-core"),
        "mochitest-webgl2-core": WebglSuite("webgl2-core"),
        "mochitest-webgl1-ext": WebglSuite("webgl1-ext"),
        "mochitest-webgl2-ext": WebglSuite("webgl2-ext"),
        "mochitest-webgl2-deqp": WebglSuite("webgl2-deqp"),
        "mochitest-chrome": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--screenshot-on-fail",
                "--flavor=chrome",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-plain-gpu": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--subsuite=gpu",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-plain-clipboard": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--subsuite=clipboard",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-media": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--chunk-by-runtime",
                "--subsuite=media",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "robocop": {
            "run_filename": "runrobocop.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--robocop-apk=../../robocop.apk",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "reftest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--httpd-path", "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--suite=reftest",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["tests/layout/reftests/reftest.list",],
        },
        "crashtest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--httpd-path",
                "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--suite=crashtest",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["tests/testing/crashtest/crashtests.list",],
        },
        "jittest": {
            "run_filename": "jit_test.py",
            "testsdir": "jit-test/jit-test",
            "options": [
                "../../bin/js",
                "--remote",
                "-j",
                "1",
                "--localLib=../../bin",
                "--no-slow",
                "--no-progress",
                "--format=automation",
                "--jitflags=all",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "jsreftest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s", "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s", "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s", "--httpd-path", "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--extra-profile-file=jsreftest/tests/user.js",
                "--suite=jstestbrowser",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["../jsreftest/tests/jstests.list",],
        },
        "xpcshell": {
            "run_filename": "remotexpcshelltests.py",
            "testsdir": "xpcshell",
            "install": False,
            "options": [
                "--xre-path=%(xre_path)s",
                "--testing-modules-dir=%(modules_dir)s",
                "--apk=%(installer_path)s",
                "--no-logfiles",
                "--symbols-path=%(symbols_path)s",
                "--manifest=tests/xpcshell.ini",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--test-plugin-path=none",
                "--deviceSerial=%(device_serial)s",
                "%(xpcshell_extra)s",
            ],
        },
        "cppunittest": {
            "run_filename": "remotecppunittests.py",
            "testsdir": "cppunittest",
            "install": False,
            "options": [
                "--symbols-path=%(symbols_path)s",
                "--xre-path=%(xre_path)s",
                "--localBinDir=../bin",
                "--apk=%(installer_path)s",
                ".",
                "--deviceSerial=%(device_serial)s",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
            ],
        },
        "marionette": {
            "run_filename": os.path.join("harness", "marionette_harness", "runtests.py"),
            "testsdir": "marionette",
            "options": [
                "--app=fennec",
                "--package=%(app)s",
                "--address=%(address)s",
                "%(test_manifest)s",
                "--disable-e10s",
                "--gecko-log=%(gecko_log)s",
                "-vv",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--symbols-path=%(symbols_path)s",
                "--startup-timeout=300",
                "--device=%(device_serial)s",
                "%(marionette_extra)s",
            ],
        },
        "geckoview-junit": {
            "run_filename": "runjunit.py",
            "testsdir": "mochitest",
            "options": [
                "--certificate-path=%(certs_path)s",
                "--remote-webserver=%(remote_webserver)s",
                "--symbols-path=%(symbols_path)s",
                "--utility-path=%(utility_path)s",
                "--deviceSerial=%(device_serial)s",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
            ],
        },
        "gtest": {
            "run_filename": "remotegtests.py",
            "testsdir": "gtest",
            "install": True,
            "options": [
                "--symbols-path=%(symbols_path)s",
                "--libxul=%(gtest_dir)s/libxul.so",
                "--package=%(app)s",
                "--deviceSerial=%(device_serial)s",
            ],
        },

    },  # end suite_definitions
}
