/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.mozilla.jss.SecretDecoderRing.Encryptor;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;

public class KeyManager {
    private static final int KEYID_LEN = 16;
    private static final String RNG_ALG = "pkcs11prng";
    private static final String RNG_PROVIDER = "Mozilla-JSS";
    public static final KeyGenAlgorithm DEFAULT_KEYGEN_ALG = KeyGenAlgorithm.DES3;
    public static final int DEFAULT_KEYSIZE = 0;
    private CryptoToken token;

    public KeyManager(CryptoToken token) {
        if (token == null) {
            throw new NullPointerException("token is null");
        }
        this.token = token;
    }

    public byte[] generateKey() throws TokenException {
        return this.generateKey(DEFAULT_KEYGEN_ALG, 0);
    }

    public byte[] generateKey(KeyGenAlgorithm alg2, int keySize) throws TokenException {
        if (alg2 == null) {
            throw new NullPointerException("alg is null");
        }
        byte[] keyID = this.generateUnusedKeyID();
        this.generateKeyNative(this.token, alg2, keyID, keySize);
        return keyID;
    }

    private native void generateKeyNative(CryptoToken var1, KeyGenAlgorithm var2, byte[] var3, int var4);

    public byte[] generateUniqueNamedKey(String nickname) throws TokenException {
        return this.generateUniqueNamedKey(DEFAULT_KEYGEN_ALG, 0, nickname);
    }

    public byte[] generateUniqueNamedKey(KeyGenAlgorithm alg2, int keySize, String nickname) throws TokenException {
        if (nickname != null) {
            nickname = nickname.trim();
        }
        if (alg2 == null) {
            throw new NullPointerException("alg is null");
        }
        if (this.uniqueNamedKeyExists(nickname)) {
            throw new NullPointerException("duplicate symmetric key");
        }
        byte[] keyID = this.generateUnusedKeyID();
        this.generateUniqueNamedKeyNative(this.token, alg2, keyID, keySize, nickname);
        return keyID;
    }

    private native void generateUniqueNamedKeyNative(CryptoToken var1, KeyGenAlgorithm var2, byte[] var3, int var4, String var5);

    private byte[] generateUnusedKeyID() throws TokenException {
        try {
            SecureRandom rng = SecureRandom.getInstance(RNG_ALG, RNG_PROVIDER);
            byte[] keyID = new byte[16];
            do {
                rng.nextBytes(keyID);
            } while (this.keyExists(keyID));
            return keyID;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("No such algorithm: pkcs11prng");
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("No such provider: Mozilla-JSS");
        }
    }

    private boolean keyExists(byte[] keyid) throws TokenException {
        return this.lookupKey(Encryptor.DEFAULT_ENCRYPTION_ALG, keyid) != null;
    }

    public SecretKey lookupKey(EncryptionAlgorithm alg2, byte[] keyid) throws TokenException {
        if (alg2 == null || keyid == null) {
            throw new NullPointerException();
        }
        SymmetricKey k = this.lookupKeyNative(this.token, alg2, keyid);
        if (k == null) {
            return null;
        }
        return new SecretKeyFacade(k);
    }

    private native SymmetricKey lookupKeyNative(CryptoToken var1, EncryptionAlgorithm var2, byte[] var3) throws TokenException;

    public boolean uniqueNamedKeyExists(String nickname) throws TokenException {
        return this.lookupUniqueNamedKey(Encryptor.DEFAULT_ENCRYPTION_ALG, nickname) != null;
    }

    public SecretKey lookupUniqueNamedKey(EncryptionAlgorithm alg2, String nickname) throws TokenException {
        if (nickname != null) {
            nickname = nickname.trim();
        }
        if (alg2 == null || nickname == null || nickname.equals("")) {
            throw new NullPointerException();
        }
        SymmetricKey k = this.lookupUniqueNamedKeyNative(this.token, alg2, nickname);
        if (k == null) {
            return null;
        }
        return new SecretKeyFacade(k);
    }

    private native SymmetricKey lookupUniqueNamedKeyNative(CryptoToken var1, EncryptionAlgorithm var2, String var3) throws TokenException;

    public void deleteKey(byte[] keyID) throws TokenException, InvalidKeyException {
        this.deleteKey(this.lookupKey(Encryptor.DEFAULT_ENCRYPTION_ALG, keyID));
    }

    public void deleteUniqueNamedKey(String nickname) throws TokenException, InvalidKeyException {
        if (this.uniqueNamedKeyExists(nickname)) {
            this.deleteKey(this.lookupUniqueNamedKey(Encryptor.DEFAULT_ENCRYPTION_ALG, nickname));
        }
    }

    public void deleteKey(SecretKey key) throws TokenException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof SecretKeyFacade)) {
            throw new InvalidKeyException("Key must be a JSS key");
        }
        this.deleteKeyNative(this.token, ((SecretKeyFacade)key).key);
    }

    private native void deleteKeyNative(CryptoToken var1, SymmetricKey var2) throws TokenException;
}

