/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;

class CountingStream
extends InputStream {
    private int count = 0;
    private int markpos;
    private InputStream source;
    private static final boolean DEBUG = false;

    private CountingStream() {
    }

    public CountingStream(InputStream source) {
        this.source = source;
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void mark(int readlimit) {
        this.source.mark(readlimit);
        this.markpos = this.count;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        int n = this.source.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    public int read(byte[] buffer) throws IOException {
        int n = this.source.read(buffer);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int n = this.source.read(buffer, offset, count);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    public void reset() throws IOException {
        this.source.reset();
        this.count = this.markpos;
    }

    public long skip(long count) throws IOException {
        this.count = (int)((long)this.count + count);
        return this.source.skip(count);
    }

    public int getNumRead() {
        return this.count;
    }

    public void resetNumRead() {
        this.count = 0;
        this.markpos = 0;
    }
}

