/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class ENUMERATED
extends INTEGER
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 10L);
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public ENUMERATED(long val) {
        super(val);
    }

    ENUMERATED(byte[] valBytes) {
        super(valBytes);
    }

    public long getValue() {
        return this.longValue();
    }

    public static ASN1Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    extends INTEGER.Template
    implements ASN1Template {
        Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(Tag tag, InputStream derStream) throws InvalidBERException, IOException {
            try {
                ASN1Header wrapper = new ASN1Header(derStream);
                wrapper.validate(tag, INTEGER.FORM);
                if (wrapper.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for ENUMERATED");
                }
                byte[] valBytes = new byte[(int)wrapper.getContentLength()];
                ASN1Util.readFully(valBytes, derStream);
                return new ENUMERATED(valBytes);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "ENUMERATED");
            }
        }
    }
}

