/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class INTEGER
extends BigInteger
implements ASN1Value {
    private byte[] encodedContents = null;
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 2L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.toByteArray();
        }
        return this.encodedContents;
    }

    private ASN1Header getHeader(Tag t) {
        return new ASN1Header(t, FORM, this.getContentLength());
    }

    public INTEGER(String s) throws NumberFormatException {
        super(s);
    }

    public INTEGER(String s, int r) throws NumberFormatException {
        super(s, r);
    }

    public INTEGER(byte[] bval) throws NumberFormatException {
        super(bval);
    }

    public INTEGER(int sign, byte[] mag) throws NumberFormatException {
        super(sign, mag);
    }

    public INTEGER(int numBits, Random rnd) throws NumberFormatException {
        super(numBits, rnd);
    }

    public INTEGER(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
    }

    public INTEGER(long val) {
        super(BigInteger.valueOf(val).toByteArray());
    }

    public INTEGER(BigInteger bi) {
        super(bi.toByteArray());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(this.getTag(), outStream);
    }

    public void encode(Tag implicitTag, OutputStream outStream) throws IOException {
        this.getHeader(implicitTag).encode(outStream);
        outStream.write(this.getEncodedContents());
    }

    public long getContentLength() {
        return this.getEncodedContents().length;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.encode(b);
        return b.toByteArray();
    }

    public static ASN1Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] args) {
        try {
            int[] Is = new int[11];
            int[][] Bs = new int[11][];
            int i = 0;
            Is[i] = 0;
            Bs[i++] = new int[]{2, 1, 0};
            Is[i] = 1;
            Bs[i++] = new int[]{2, 1, 1};
            Is[i] = -1;
            Bs[i++] = new int[]{2, 1, 255};
            Is[i] = 127;
            Bs[i++] = new int[]{2, 1, 127};
            Is[i] = 128;
            Bs[i++] = new int[]{2, 2, 0, 128};
            Is[i] = 255;
            Bs[i++] = new int[]{2, 2, 0, 255};
            Is[i] = 256;
            Bs[i++] = new int[]{2, 2, 1, 0};
            Is[i] = -128;
            Bs[i++] = new int[]{2, 1, 128};
            Is[i] = -129;
            Bs[i++] = new int[]{2, 2, 255, 127};
            Is[i] = 43568;
            Bs[i++] = new int[]{2, 3, 0, 170, 48};
            Is[i] = -43568;
            Bs[i++] = new int[]{2, 3, 255, 85, 208};
            for (i = 0; i < Is.length; ++i) {
                ByteArrayInputStream bis;
                Template template;
                INTEGER create;
                INTEGER I = new INTEGER(Is[i]);
                byte[] compare = I.encode();
                if (!INTEGER.arraysEqual(compare, Bs[i])) {
                    System.err.println("Encoding FAILED: " + Is[i]);
                    System.exit(-1);
                }
                if ((create = (INTEGER)(template = new Template()).decode(bis = new ByteArrayInputStream(compare))).intValue() == Is[i]) continue;
                System.err.println("Decoding FAILED: " + Is[i]);
                System.exit(-1);
            }
            System.out.println("PASS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean arraysEqual(byte[] bytes, int[] ints) {
        if (bytes == null || ints == null) {
            return false;
        }
        if (bytes.length != ints.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == (byte)ints[i]) continue;
            return false;
        }
        return true;
    }

    public static class Template
    implements ASN1Template {
        Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream derStream) throws InvalidBERException, IOException {
            return this.decode(this.getTag(), derStream);
        }

        public ASN1Value decode(Tag tag, InputStream derStream) throws InvalidBERException, IOException {
            try {
                ASN1Header wrapper = new ASN1Header(derStream);
                wrapper.validate(tag, FORM);
                if (wrapper.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for INTEGER");
                }
                byte[] valBytes = new byte[(int)wrapper.getContentLength()];
                ASN1Util.readFully(valBytes, derStream);
                return new INTEGER(valBytes);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "INTEGER");
            }
        }
    }
}

