/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.util.Vector;

public class InvalidBERException
extends Exception {
    private InvalidBERException child = null;
    private Vector mesgList = new Vector();

    public InvalidBERException(String mesg) {
        super(mesg);
    }

    public void append(String mesg) {
        this.mesgList.addElement(mesg);
    }

    public InvalidBERException(InvalidBERException e, String mesg) {
        super(mesg);
        this.child = e;
    }

    private void appendMessages(StringBuffer sb) {
        int numMessages = this.mesgList.size();
        for (int i = numMessages - 1; i >= 0; --i) {
            sb.append(this.mesgList.elementAt(i));
            sb.append(" >> ");
        }
        sb.append(this.getMessage());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(": ");
        this.appendMessages(sb);
        return sb.toString();
    }

    public String toStringNested() {
        StringBuffer sb = new StringBuffer();
        this.appendMessages(sb);
        if (this.child != null) {
            sb.append(" >> ");
            sb.append(this.child.toStringNested());
        }
        return sb.toString();
    }

    public static class InvalidChar
    extends InvalidBERException {
        public InvalidChar(byte b, int offset) {
            super("Invalid character (" + b + ") encountered at offset " + offset);
        }

        public InvalidChar(char c, int offset) {
            super("Invalid character (" + c + ") encountered at offset" + offset);
        }
    }

    public static class EOF
    extends InvalidBERException {
        public EOF() {
            super("Unexpected end-of-file encountered");
        }
    }
}

