/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class OBJECT_IDENTIFIER
implements ASN1Value {
    public static final OBJECT_IDENTIFIER RSADSI = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L});
    public static final OBJECT_IDENTIFIER PKCS = RSADSI.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS1 = PKCS.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS2 = PKCS.subBranch(2L);
    public static final OBJECT_IDENTIFIER RSA_DIGEST = RSADSI.subBranch(2L);
    public static final OBJECT_IDENTIFIER PKCS5 = PKCS.subBranch(5L);
    public static final OBJECT_IDENTIFIER PKCS9 = PKCS.subBranch(9L);
    public static final OBJECT_IDENTIFIER PKCS12 = PKCS.subBranch(12L);
    public static final OBJECT_IDENTIFIER RSA_CIPHER = RSADSI.subBranch(3L);
    public static final OBJECT_IDENTIFIER ALGORITHM = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 14L, 3L, 2L});
    public static final OBJECT_IDENTIFIER HASH_ALGORITHM = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 2L});
    public static final OBJECT_IDENTIFIER PKIX = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L});
    public static final OBJECT_IDENTIFIER id_cmc = PKIX.subBranch(7L);
    public static final OBJECT_IDENTIFIER id_cmc_cMCStatusInfo = id_cmc.subBranch(1L);
    public static final OBJECT_IDENTIFIER id_cmc_identification = id_cmc.subBranch(2L);
    public static final OBJECT_IDENTIFIER id_cmc_identityProof = id_cmc.subBranch(3L);
    public static final OBJECT_IDENTIFIER id_cmc_dataReturn = id_cmc.subBranch(4L);
    public static final OBJECT_IDENTIFIER id_cmc_transactionId = id_cmc.subBranch(5L);
    public static final OBJECT_IDENTIFIER id_cmc_senderNonce = id_cmc.subBranch(6L);
    public static final OBJECT_IDENTIFIER id_cmc_recipientNonce = id_cmc.subBranch(7L);
    public static final OBJECT_IDENTIFIER id_cmc_addExtensions = id_cmc.subBranch(8L);
    public static final OBJECT_IDENTIFIER id_cmc_encryptedPOP = id_cmc.subBranch(9L);
    public static final OBJECT_IDENTIFIER id_cmc_decryptedPOP = id_cmc.subBranch(10L);
    public static final OBJECT_IDENTIFIER id_cmc_lraPOPWitness = id_cmc.subBranch(11L);
    public static final OBJECT_IDENTIFIER id_cmc_getCert = id_cmc.subBranch(15L);
    public static final OBJECT_IDENTIFIER id_cmc_getCRL = id_cmc.subBranch(16L);
    public static final OBJECT_IDENTIFIER id_cmc_revokeRequest = id_cmc.subBranch(17L);
    public static final OBJECT_IDENTIFIER id_cmc_regInfo = id_cmc.subBranch(18L);
    public static final OBJECT_IDENTIFIER id_cmc_responseInfo = id_cmc.subBranch(19L);
    public static final OBJECT_IDENTIFIER id_cmc_QueryPending = id_cmc.subBranch(21L);
    public static final OBJECT_IDENTIFIER id_cmc_idPOPLinkRandom = id_cmc.subBranch(22L);
    public static final OBJECT_IDENTIFIER id_cmc_idPOPLinkWitness = id_cmc.subBranch(23L);
    public static final OBJECT_IDENTIFIER id_cmc_idConfirmCertAcceptance = id_cmc.subBranch(24L);
    public static final OBJECT_IDENTIFIER id_cct = PKIX.subBranch(12L);
    public static final OBJECT_IDENTIFIER id_cct_PKIData = id_cct.subBranch(2L);
    public static final OBJECT_IDENTIFIER id_cct_PKIResponse = id_cct.subBranch(3L);
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 6L);
    public static final Form FORM = Form.PRIMITIVE;
    private long[] numbers;
    private byte[] encodedContents = null;
    byte[] cachedEncoding = null;
    Tag tagForCache = null;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public OBJECT_IDENTIFIER(long[] numbers) {
        OBJECT_IDENTIFIER.checkLongArray(numbers);
        this.numbers = numbers;
    }

    private static void checkLongArray(long[] numbers) {
        Assert._assert(numbers != null);
        if (numbers == null) {
            throw new NullPointerException();
        }
        Assert._assert(numbers.length >= 2);
        Assert._assert(numbers[0] == 0L || numbers[0] == 1L || numbers[0] == 2L);
    }

    public OBJECT_IDENTIFIER(String dottedOID) throws NumberFormatException {
        if (dottedOID == null || dottedOID.length() == 0) {
            throw new NumberFormatException("OID string is zero-length");
        }
        StringTokenizer stok = new StringTokenizer(dottedOID, ".");
        this.numbers = new long[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreElements()) {
            this.numbers[i++] = Long.parseLong(stok.nextToken());
        }
        Assert._assert(i == this.numbers.length);
        OBJECT_IDENTIFIER.checkLongArray(this.numbers);
    }

    public long[] getNumbers() {
        return this.numbers;
    }

    public int hashCode() {
        int code = 1;
        for (int i = 0; i < this.numbers.length; ++i) {
            code = (int)((long)code + this.numbers[i]) * 10;
        }
        return code;
    }

    public OBJECT_IDENTIFIER subBranch(long num) {
        long[] nums = new long[this.numbers.length + 1];
        System.arraycopy(this.numbers, 0, nums, 0, this.numbers.length);
        nums[this.numbers.length] = num;
        return new OBJECT_IDENTIFIER(nums);
    }

    public OBJECT_IDENTIFIER subBranch(long[] newNums) {
        long[] nums = new long[this.numbers.length + newNums.length];
        System.arraycopy(this.numbers, 0, nums, 0, this.numbers.length);
        System.arraycopy(newNums, 0, nums, this.numbers.length, newNums.length);
        return new OBJECT_IDENTIFIER(nums);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OBJECT_IDENTIFIER)) {
            return false;
        }
        long[] nums = ((OBJECT_IDENTIFIER)obj).numbers;
        if (nums.length != this.numbers.length) {
            return false;
        }
        for (int i = 0; i < nums.length; ++i) {
            if (nums[i] == this.numbers[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = "{" + String.valueOf(this.numbers[0]);
        for (int i = 1; i < this.numbers.length; ++i) {
            ret = ret + " " + this.numbers[i];
        }
        ret = ret + "}";
        return ret;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.computeEncodedContents();
        }
        return this.encodedContents;
    }

    private byte[] getEncoding(Tag tag) {
        if (!tag.equals(this.tagForCache)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ASN1Header head = this.getHeader(tag);
            try {
                head.encode(out);
            }
            catch (IOException e) {
                Assert.notReached("exception while encoding ASN.1 header");
            }
            out.write(this.getEncodedContents(), 0, this.getEncodedContents().length);
            this.tagForCache = tag;
            this.cachedEncoding = out.toByteArray();
        }
        return this.cachedEncoding;
    }

    private ASN1Header getHeader(Tag implicitTag) {
        return new ASN1Header(implicitTag, FORM, this.getEncodedContents().length);
    }

    private byte[] computeEncodedContents() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert._assert(this.numbers.length >= 2);
        long n = this.numbers[0];
        Assert._assert(n == 0L || n == 1L || n == 2L);
        long outb = this.numbers[0] * 40L + this.numbers[1];
        Assert._assert((long)((byte)outb) == outb);
        out.write((byte)outb);
        for (int i = 2; i < this.numbers.length; ++i) {
            n = this.numbers[i];
            Assert._assert(n >= 0L);
            byte[] rev = new byte[10];
            int idx = 0;
            do {
                rev[idx++] = (byte)(n % 128L);
            } while ((n /= 128L) > 0L);
            --idx;
            while (idx > 0) {
                out.write(rev[idx--] | 0x80);
            }
            Assert._assert(idx == 0);
            out.write(rev[0]);
        }
        return out.toByteArray();
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        ostream.write(this.getEncoding(implicitTag));
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public Form getForm() {
            return FORM;
        }

        public boolean formMatch(Form form) {
            return form == FORM;
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = new ASN1Header(istream);
                long remainingContent = head.getContentLength();
                if (!head.getTag().equals(implicitTag)) {
                    throw new InvalidBERException("Incorrect tag for OBJECT IDENTIFIER: " + head.getTag());
                }
                if (head.getForm() != this.getForm()) {
                    throw new InvalidBERException("Incorrect form for OBJECT IDENTIFIER");
                }
                if (remainingContent < 1L) {
                    throw new InvalidBERException("Invalid 0 length for OBJECT IDENTIFIER");
                }
                Vector<Long> numberV = new Vector<Long>();
                byte b = Template.readByte(istream);
                --remainingContent;
                long num = b % 40;
                numberV.addElement(new Long(b % 40));
                numberV.insertElementAt(new Long(b / 40), 0);
                while (remainingContent > 0L) {
                    num = 0L;
                    int bitcount = 0;
                    do {
                        if ((bitcount += 7) > 63) {
                            throw new InvalidBERException("OBJECT IDENTIFIER element too long; max is 63 bits");
                        }
                        b = Template.readByte(istream);
                        --remainingContent;
                        num <<= 7;
                        num |= (long)(b & 0x7F);
                    } while ((b & 0x80) != 0);
                    numberV.addElement(new Long(num));
                }
                long[] numbers = new long[numberV.size()];
                for (int i = 0; i < numbers.length; ++i) {
                    numbers[i] = (Long)numberV.elementAt(i);
                }
                return new OBJECT_IDENTIFIER(numbers);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "OBJECT IDENTIFIER");
            }
        }

        private static byte readByte(InputStream istream) throws InvalidBERException, IOException {
            int n = istream.read();
            if (n == -1) {
                throw new InvalidBERException("End-of-file reached while decoding OBJECT IDENTIFIER");
            }
            Assert._assert((n & 0xFF) == n);
            return (byte)n;
        }
    }
}

