/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.Tag;

public class PrintableString
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 19L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    public PrintableString(char[] chars) throws CharConversionException {
        super(chars);
    }

    public PrintableString(String s) throws CharConversionException {
        super(s);
    }

    CharConverter getCharConverter() {
        return new PrintableConverter();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class PrintableConverter
    implements CharConverter {
        private static boolean[] isPrintable;

        private PrintableConverter() {
        }

        public char[] byteToChar(byte[] bytes, int offset, int len) throws CharConversionException {
            char[] chars = new char[len];
            int b = offset;
            for (int c = 0; c < len; ++c) {
                if ((bytes[b] & 0x80) == 0 && isPrintable[bytes[b]]) {
                    chars[c] = (char)bytes[b];
                }
                ++b;
            }
            return chars;
        }

        public byte[] charToByte(char[] chars, int offset, int len) throws CharConversionException {
            byte[] bytes = new byte[len];
            int c = 0;
            int b = 0;
            while (b < len) {
                if ((chars[c] & 0xFF80) != 0 || !isPrintable[chars[c]]) {
                    throw new CharConversionException(chars[c] + " is not " + "a valid character for a PrintableString");
                }
                bytes[b] = (byte)(chars[c] & 0x7F);
                ++b;
                ++c;
            }
            return bytes;
        }

        static {
            int b;
            isPrintable = new boolean[128];
            for (b = 65; b <= 90; b = (int)((char)(b + 1))) {
                PrintableConverter.isPrintable[b] = true;
            }
            for (b = 97; b <= 122; b = (int)((char)(b + 1))) {
                PrintableConverter.isPrintable[b] = true;
            }
            for (b = 48; b <= 57; b = (int)((char)(b + 1))) {
                PrintableConverter.isPrintable[b] = true;
            }
            PrintableConverter.isPrintable[32] = true;
            PrintableConverter.isPrintable[39] = true;
            PrintableConverter.isPrintable[40] = true;
            PrintableConverter.isPrintable[41] = true;
            PrintableConverter.isPrintable[43] = true;
            PrintableConverter.isPrintable[44] = true;
            PrintableConverter.isPrintable[45] = true;
            PrintableConverter.isPrintable[46] = true;
            PrintableConverter.isPrintable[47] = true;
            PrintableConverter.isPrintable[58] = true;
            PrintableConverter.isPrintable[61] = true;
            PrintableConverter.isPrintable[63] = true;
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected CharConverter getCharConverter() {
            return new PrintableConverter();
        }

        protected CharacterString generateInstance(char[] chars) throws CharConversionException {
            return new PrintableString(chars);
        }

        protected String typeName() {
            return "PrintableString";
        }
    }
}

