/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import org.mozilla.jss.asn1.InvalidBERException;

public class Tag {
    private long num;
    private Class tClass;
    public static final Class UNIVERSAL = Class.UNIVERSAL;
    public static final Class APPLICATION = Class.APPLICATION;
    public static final Class CONTEXT_SPECIFIC = Class.CONTEXT_SPECIFIC;
    public static final Class PRIVATE = Class.PRIVATE;
    public static final Tag END_OF_CONTENTS;
    public static final Tag EOC;
    private static final int numTagInstances = 10;
    private static Tag[] tagInstances;

    public long getNum() {
        return this.num;
    }

    public Class getTagClass() {
        return this.tClass;
    }

    private Tag() {
    }

    public Tag(Class clazz, long num) {
        this.tClass = clazz;
        this.num = num;
    }

    public Tag(long num) {
        this(Class.CONTEXT_SPECIFIC, num);
    }

    public static Tag get(long num) {
        if (num >= 0L && num < 10L) {
            return tagInstances[(int)num];
        }
        return new Tag(num);
    }

    public int hashCode() {
        return this.tClass.toInt() * 131 + (int)this.num;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag t = (Tag)obj;
        return this.num == t.num && this.tClass == t.tClass;
    }

    public String toString() {
        return this.tClass + " " + this.num;
    }

    static {
        EOC = END_OF_CONTENTS = new Tag(UNIVERSAL, 0L);
        tagInstances = new Tag[10];
        for (int i = 0; i < 10; ++i) {
            Tag.tagInstances[i] = new Tag(i);
        }
    }

    public static class Class {
        private int encoding;
        private String name;
        public static final Class UNIVERSAL = new Class(0, "UNIVERSAL");
        public static final Class APPLICATION = new Class(1, "APPLICATION");
        public static final Class CONTEXT_SPECIFIC = new Class(2, "CONTEXT-SPECIFIC");
        public static final Class PRIVATE = new Class(3, "PRIVATE");

        private Class() {
        }

        private Class(int enc, String name) {
            this.encoding = enc;
            this.name = name;
        }

        public int toInt() {
            return this.encoding;
        }

        public String toString() {
            return this.name;
        }

        public static Class fromInt(int i) throws InvalidBERException {
            if (i == 0) {
                return UNIVERSAL;
            }
            if (i == 1) {
                return APPLICATION;
            }
            if (i == 2) {
                return CONTEXT_SPECIFIC;
            }
            if (i == 3) {
                return PRIVATE;
            }
            throw new InvalidBERException("Invalid tag class: " + i);
        }
    }
}

