/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class UniversalString
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 28L);
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public UniversalString(char[] chars) throws CharConversionException {
        super(chars);
    }

    public UniversalString(String s) throws CharConversionException {
        super(s);
    }

    CharConverter getCharConverter() {
        return new UniversalConverter();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class UniversalConverter
    implements CharConverter {
        public static final int MAX_UNICODE = 65535;
        public static final int MAX_UTF16 = 0x10FFFF;
        public static final char REPLACEMENT_CHAR = '\ufffd';
        public static final int UTF16_BASE = 0x100000;
        public static final int HALF_SHIFT = 10;
        public static final int HALF_MASK = 1023;
        public static final int UTF16_HIGH_START = 55296;
        public static final int UTF16_HIGH_END = 56575;
        public static final int UTF16_LOW_START = 56320;
        public static final int UTF16_LOW_END = 57343;

        private UniversalConverter() {
        }

        public char[] byteToChar(byte[] bytes, int offset, int len) throws CharConversionException {
            CharArrayWriter out = new CharArrayWriter(len / 4);
            int end = offset + len;
            while (offset < end) {
                if (end - offset < 4) {
                    throw new CharConversionException("input exhausted");
                }
                int ucs4 = (bytes[offset++] & 0xFF) << 24;
                ucs4 += (bytes[offset++] & 0xFF) << 16;
                ucs4 += (bytes[offset++] & 0xFF) << 8;
                if ((ucs4 += bytes[offset++] & 0xFF) <= 65535) {
                    out.write(ucs4 & 0xFFFF);
                    continue;
                }
                if (ucs4 <= 0x10FFFF) {
                    out.write(((ucs4 -= 0x100000) >>> 10) + 55296);
                    out.write((ucs4 & 0x3FF) + 56320);
                    continue;
                }
                out.write(65533);
            }
            return out.toCharArray();
        }

        public byte[] charToByte(char[] chars, int offset, int len) throws CharConversionException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(len * 4);
            int end = offset + len;
            while (offset < end) {
                int ucs4;
                char c;
                if ((c = chars[offset++]) >= '\ud800' && c <= '\udcff') {
                    char low;
                    if (offset == end) {
                        throw new CharConversionException("input exhausted");
                    }
                    if ((low = chars[offset++]) < '\udc00' || low > '\udfff') {
                        throw new CharConversionException("UTF16 high character not followed by a UTF16 low character");
                    }
                    ucs4 = 0x100000;
                    ucs4 += c - 55296 << 10;
                    ucs4 += low - 56320;
                } else {
                    ucs4 = c & 0xFFFF;
                }
                out.write((ucs4 & 0xFF000000) >>> 24);
                out.write((ucs4 & 0xFF0000) >>> 16);
                out.write((ucs4 & 0xFF00) >>> 8);
                out.write(ucs4 & 0xFF);
            }
            return out.toByteArray();
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected CharConverter getCharConverter() {
            return new UniversalConverter();
        }

        protected CharacterString generateInstance(char[] chars) throws CharConversionException {
            return new UniversalString(chars);
        }

        protected String typeName() {
            return "UniversalString";
        }
    }
}

