/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Assert;

public abstract class Cipher {
    public abstract void initEncrypt(SymmetricKey var1) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initDecrypt(SymmetricKey var1) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initEncrypt(SymmetricKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initDecrypt(SymmetricKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract byte[] update(byte[] var1) throws IllegalStateException, TokenException;

    public abstract byte[] update(byte[] var1, int var2, int var3) throws IllegalStateException, TokenException;

    public abstract byte[] doFinal(byte[] var1) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public abstract byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public static byte[] pad(byte[] toBePadded, int blockSize) {
        Assert._assert(blockSize > 0);
        byte padOctet = (byte)(blockSize - toBePadded.length % blockSize);
        byte[] padded = new byte[toBePadded.length + padOctet];
        System.arraycopy(toBePadded, 0, padded, 0, toBePadded.length);
        for (int i = toBePadded.length; i < padded.length; ++i) {
            padded[i] = padOctet;
        }
        return padded;
    }

    public static byte[] unPad(byte[] padded, int blockSize) throws BadPaddingException {
        if (padded.length == 0) {
            return new byte[0];
        }
        if (padded.length < blockSize) {
            throw new BadPaddingException("Length of padded array is less than one block");
        }
        byte padOctet = padded[padded.length - 1];
        if (padOctet > blockSize) {
            throw new BadPaddingException("Padding octet (" + padOctet + ") is " + "larger than block size (" + blockSize + ")");
        }
        if (padOctet < 1) {
            throw new BadPaddingException("Padding octet is less than 1");
        }
        byte[] unpadded = new byte[padded.length - padOctet];
        System.arraycopy(padded, 0, unpadded, 0, unpadded.length);
        return unpadded;
    }

    public static byte[] unPad(byte[] padded) throws BadPaddingException {
        if (padded.length == 0) {
            return new byte[0];
        }
        byte padOctet = padded[padded.length - 1];
        if (padOctet < 1) {
            throw new BadPaddingException("Padding octet is less than 1");
        }
        if (padOctet >= padded.length) {
            throw new BadPaddingException("Padding is larger than entire array");
        }
        byte[] unpadded = new byte[padded.length - padOctet];
        System.arraycopy(padded, 0, unpadded, 0, unpadded.length);
        return unpadded;
    }
}

