/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;

public class EncryptionAlgorithm
extends Algorithm {
    private int blockSize;
    private Alg alg;
    private Mode mode;
    private Padding padding;
    private int keyStrength;
    private static Hashtable oidMap = new Hashtable();
    private static Hashtable nameMap = new Hashtable();
    private static Vector algList = new Vector();
    private static Class[] IVParameterSpecClasses = null;
    public static final EncryptionAlgorithm RC4;
    public static final EncryptionAlgorithm DES_ECB;
    public static final EncryptionAlgorithm DES_CBC;
    public static final EncryptionAlgorithm DES_CBC_PAD;
    public static final EncryptionAlgorithm DES3_ECB;
    public static final EncryptionAlgorithm DES3_CBC;
    public static final EncryptionAlgorithm DES3_CBC_PAD;
    public static final EncryptionAlgorithm RC2_CBC;
    public static final EncryptionAlgorithm RC2_CBC_PAD;
    public static final OBJECT_IDENTIFIER AES_ROOT_OID;
    public static final EncryptionAlgorithm AES_128_ECB;
    public static final EncryptionAlgorithm AES_128_CBC;
    public static final EncryptionAlgorithm AES_128_CBC_PAD;
    public static final EncryptionAlgorithm AES_192_ECB;
    public static final EncryptionAlgorithm AES_192_CBC;
    public static final EncryptionAlgorithm AES_192_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_ECB;
    public static final EncryptionAlgorithm AES_256_CBC;
    public static final EncryptionAlgorithm AES_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_CBC_PAD;
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;

    private static String makeName(Alg alg2, Mode mode, Padding padding) {
        StringBuffer buf = new StringBuffer();
        buf.append(alg2.toString());
        buf.append('/');
        buf.append(mode.toString());
        buf.append('/');
        buf.append(padding.toString());
        return buf.toString();
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg2, Mode mode, Padding padding, Class paramClass, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength) {
        super(oidTag, EncryptionAlgorithm.makeName(alg2, mode, padding), oid, paramClass);
        this.alg = alg2;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg2, Mode mode, Padding padding, Class[] paramClasses, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength) {
        super(oidTag, EncryptionAlgorithm.makeName(alg2, mode, padding), oid, paramClasses);
        this.alg = alg2;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    public Alg getAlg() {
        return this.alg;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public int getKeyStrength() {
        return this.keyStrength;
    }

    public static EncryptionAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg2 = oidMap.get(oid);
        if (alg2 == null) {
            throw new NoSuchAlgorithmException("OID: " + oid.toString());
        }
        return (EncryptionAlgorithm)alg2;
    }

    public static EncryptionAlgorithm fromString(String name) throws NoSuchAlgorithmException {
        Object alg2 = nameMap.get(name.toLowerCase());
        if (alg2 == null) {
            throw new NoSuchAlgorithmException();
        }
        return (EncryptionAlgorithm)alg2;
    }

    public static EncryptionAlgorithm lookup(String algName, String modeName, String paddingName, int keyStrength) throws NoSuchAlgorithmException {
        int i;
        int len = algList.size();
        Alg alg2 = Alg.fromString(algName);
        Mode mode = Mode.fromString(modeName);
        Padding padding = Padding.fromString(paddingName);
        for (i = 0; i < len; ++i) {
            EncryptionAlgorithm cur = (EncryptionAlgorithm)algList.elementAt(i);
            if (cur.alg == alg2 && cur.mode == mode && cur.padding == padding && (cur.keyStrength == 0 || cur.keyStrength == keyStrength)) break;
        }
        if (i == len) {
            throw new NoSuchAlgorithmException(algName + "/" + modeName + "/" + paddingName + " with key strength " + keyStrength + " not found");
        }
        return (EncryptionAlgorithm)algList.elementAt(i);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPadded() {
        return !Padding.NONE.equals(this.padding);
    }

    public Padding getPaddingType() {
        return this.padding;
    }

    public native int getIVLength();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IVParameterSpecClasses = new Class[2];
        EncryptionAlgorithm.IVParameterSpecClasses[0] = class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec;
        EncryptionAlgorithm.IVParameterSpecClasses[1] = class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = EncryptionAlgorithm.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec;
        RC4 = new EncryptionAlgorithm(8, Alg.RC4, Mode.NONE, Padding.NONE, (Class)null, 1, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(4L), 0);
        DES_ECB = new EncryptionAlgorithm(9, Alg.DES, Mode.ECB, Padding.NONE, (Class)null, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(6L), 56);
        DES_CBC = new EncryptionAlgorithm(10, Alg.DES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(7L), 56);
        DES_CBC_PAD = new EncryptionAlgorithm(11, Alg.DES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 56);
        DES3_ECB = new EncryptionAlgorithm(12, Alg.DESede, Mode.ECB, Padding.NONE, (Class)null, 8, null, 168);
        DES3_CBC = new EncryptionAlgorithm(13, Alg.DESede, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(7L), 168);
        DES3_CBC_PAD = new EncryptionAlgorithm(14, Alg.DESede, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 168);
        RC2_CBC = new EncryptionAlgorithm(30, Alg.RC2, Mode.CBC, Padding.NONE, class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = EncryptionAlgorithm.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec, 8, null, 0);
        RC2_CBC_PAD = new EncryptionAlgorithm(36, Alg.RC2, Mode.CBC, Padding.PKCS5, class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = EncryptionAlgorithm.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(2L), 0);
        AES_ROOT_OID = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 1L});
        AES_128_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(1L), 128);
        AES_128_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(2L), 128);
        AES_128_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 128);
        AES_192_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(21L), 192);
        AES_192_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(22L), 192);
        AES_192_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 192);
        AES_256_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(41L), 256);
        AES_256_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(42L), 256);
        AES_256_CBC_PAD = AES_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 256);
    }

    public static class Padding {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Padding NONE = new Padding("NoPadding");
        public static final Padding PKCS5 = new Padding("PKCS5Padding");

        private Padding() {
        }

        private Padding(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        public String toString() {
            return this.name;
        }

        public static Padding fromString(String name) throws NoSuchAlgorithmException {
            Padding p = (Padding)nameHash.get(name.toLowerCase());
            if (p == null) {
                throw new NoSuchAlgorithmException("Unrecognized Padding type \"" + name + "\"");
            }
            return p;
        }
    }

    public static class Alg {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Alg RC4 = new Alg("RC4");
        public static final Alg DES = new Alg("DES");
        public static final Alg DESede = new Alg("DESede");
        public static final Alg AES = new Alg("AES");
        public static final Alg RC2 = new Alg("RC2");

        private Alg() {
        }

        private Alg(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        private static Alg fromString(String name) throws NoSuchAlgorithmException {
            Alg a = (Alg)nameHash.get(name.toLowerCase());
            if (a == null) {
                throw new NoSuchAlgorithmException("Unrecognized algorithm \"" + name + "\"");
            }
            return a;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Mode {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Mode NONE = new Mode("NONE");
        public static final Mode ECB = new Mode("ECB");
        public static final Mode CBC = new Mode("CBC");

        private Mode() {
        }

        private Mode(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        public static Mode fromString(String name) throws NoSuchAlgorithmException {
            Mode m = (Mode)nameHash.get(name.toLowerCase());
            if (m == null) {
                throw new NoSuchAlgorithmException("Unrecognized mode \"" + name + "\"");
            }
            return m;
        }

        public String toString() {
            return this.name;
        }
    }
}

