/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.DigestAlgorithm;

public class HMACAlgorithm
extends DigestAlgorithm {
    private static Hashtable oidMap = new Hashtable();
    public static final HMACAlgorithm SHA1 = new HMACAlgorithm(27, "SHA-1-HMAC", OBJECT_IDENTIFIER.ALGORITHM.subBranch(26L), 20);
    public static final HMACAlgorithm SHA256 = new HMACAlgorithm(50, "SHA-256-HMAC", OBJECT_IDENTIFIER.RSA_DIGEST.subBranch(9L), 32);
    public static final HMACAlgorithm SHA384 = new HMACAlgorithm(51, "SHA-384-HMAC", OBJECT_IDENTIFIER.RSA_DIGEST.subBranch(10L), 48);
    public static final HMACAlgorithm SHA512 = new HMACAlgorithm(52, "SHA-512-HMAC", OBJECT_IDENTIFIER.RSA_DIGEST.subBranch(11L), 64);

    protected HMACAlgorithm(int oidIndex, String name, OBJECT_IDENTIFIER oid, int outputSize) {
        super(oidIndex, name, oid, outputSize);
        if (oid != null && oidMap.get(oid) == null) {
            oidMap.put(oid, this);
        }
    }

    public static DigestAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg2 = oidMap.get(oid);
        if (alg2 == null) {
            throw new NoSuchAlgorithmException();
        }
        return (HMACAlgorithm)alg2;
    }
}

