/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;

public class KeyGenAlgorithm
extends Algorithm {
    private static final OBJECT_IDENTIFIER PKCS5 = OBJECT_IDENTIFIER.PKCS5;
    private static final OBJECT_IDENTIFIER PKCS12_PBE = OBJECT_IDENTIFIER.PKCS12.subBranch(1L);
    private static Hashtable oidMap = new Hashtable();
    private KeyStrengthValidator keyStrengthValidator;
    public static final KeyGenAlgorithm DES = new KeyGenAlgorithm(15, "DES", new FixedKeyStrengthValidator(56), null, null);
    public static final KeyGenAlgorithm DES3;
    public static final KeyGenAlgorithm DESede;
    public static final KeyGenAlgorithm RC4;
    public static final KeyGenAlgorithm PBA_SHA1_HMAC;
    public static final KeyGenAlgorithm AES;
    public static final KeyGenAlgorithm RC2;
    static /* synthetic */ Class class$org$mozilla$jss$crypto$PBEKeyGenParams;

    protected KeyGenAlgorithm(int oidTag, String name, KeyStrengthValidator keyStrengthValidator, OBJECT_IDENTIFIER oid, Class paramClass) {
        super(oidTag, name, oid, paramClass);
        this.keyStrengthValidator = keyStrengthValidator;
        if (oid != null) {
            oidMap.put(oid, this);
        }
    }

    public static KeyGenAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg2 = oidMap.get(oid);
        if (alg2 == null) {
            throw new NoSuchAlgorithmException(oid.toString());
        }
        return (KeyGenAlgorithm)alg2;
    }

    public boolean isValidStrength(int strength) {
        return this.keyStrengthValidator.isValidKeyStrength(strength);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DESede = DES3 = new KeyGenAlgorithm(16, "DESede", new FixedKeyStrengthValidator(168), null, null);
        RC4 = new KeyGenAlgorithm(17, "RC4", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int strength) {
                return true;
            }
        }, null, null);
        PBA_SHA1_HMAC = new KeyGenAlgorithm(31, "PBA/SHA1/HMAC", new FixedKeyStrengthValidator(160), null, class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = KeyGenAlgorithm.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams);
        AES = new KeyGenAlgorithm(32, "AES", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int strength) {
                return strength == 128 || strength == 192 || strength == 256;
            }
        }, null, null);
        RC2 = new KeyGenAlgorithm(37, "RC2", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int strength) {
                return strength >= 8 && strength <= 1024;
            }
        }, null, null);
    }

    protected static class FixedKeyStrengthValidator
    implements KeyStrengthValidator {
        private int strength;

        public FixedKeyStrengthValidator(int strength) {
            this.strength = strength;
        }

        public boolean isValidKeyStrength(int strength) {
            return this.strength == strength;
        }
    }

    protected static interface KeyStrengthValidator {
        public boolean isValidKeyStrength(int var1);
    }
}

