/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.TokenException;

public abstract class KeyPairGeneratorSpi {
    public abstract void initialize(int var1, SecureRandom var2);

    public abstract void initialize(AlgorithmParameterSpec var1, SecureRandom var2) throws InvalidAlgorithmParameterException;

    public abstract KeyPair generateKeyPair() throws TokenException;

    public abstract void temporaryPairs(boolean var1);

    public abstract void sensitivePairs(boolean var1);

    public abstract void extractablePairs(boolean var1);

    public abstract boolean keygenOnInternalToken();

    public abstract void setKeyPairUsages(Usage[] var1, Usage[] var2);

    public static final class Usage {
        private int val;
        public static final Usage ENCRYPT = new Usage(0);
        public static final Usage DECRYPT = new Usage(1);
        public static final Usage SIGN = new Usage(2);
        public static final Usage SIGN_RECOVER = new Usage(3);
        public static final Usage VERIFY = new Usage(4);
        public static final Usage VERIFY_RECOVER = new Usage(5);
        public static final Usage WRAP = new Usage(6);
        public static final Usage UNWRAP = new Usage(7);
        public static final Usage DERIVE = new Usage(8);

        private Usage() {
        }

        private Usage(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }
}

