/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SignatureSpi;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Assert;

public class Signature {
    protected SignatureAlgorithm algorithm;
    protected SignatureSpi engine;

    protected Signature() {
    }

    Signature(SignatureAlgorithm algorithm, SignatureSpi engine) {
        this.algorithm = algorithm;
        this.engine = engine;
    }

    public Provider getProvider() {
        Assert.notYetImplemented("Signature.getProvider");
        return null;
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException, TokenException {
        this.engine.engineInitSign(privateKey);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException, TokenException {
        this.engine.engineInitVerify(publicKey);
    }

    public void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, TokenException {
        this.engine.engineSetParameter(params);
    }

    public byte[] sign() throws SignatureException, TokenException {
        return this.engine.engineSign();
    }

    public int sign(byte[] outbuf, int offset, int len) throws SignatureException, TokenException {
        return this.engine.engineSign(outbuf, offset, len);
    }

    public boolean verify(byte[] signature) throws SignatureException, TokenException {
        return this.engine.engineVerify(signature);
    }

    public void update(byte b) throws SignatureException, TokenException {
        this.engine.engineUpdate(b);
    }

    public void update(byte[] data) throws SignatureException, TokenException {
        this.engine.engineUpdate(data, 0, data.length);
    }

    public void update(byte[] data, int off, int len) throws SignatureException, TokenException {
        this.engine.engineUpdate(data, off, len);
    }

    public String getAlgorithm() {
        return this.algorithm.toString();
    }

    public SignatureAlgorithm getAlgorithmID() {
        return this.algorithm;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

