/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.DigestAlgorithm;

public class SignatureAlgorithm
extends Algorithm {
    private static Hashtable oidMap = new Hashtable();
    private SignatureAlgorithm signingAlg;
    private DigestAlgorithm digestAlg;
    public static final SignatureAlgorithm RSASignature = new SignatureAlgorithm(4, "RSA", null, null, OBJECT_IDENTIFIER.PKCS1.subBranch(1L));
    public static final SignatureAlgorithm DSASignature = new SignatureAlgorithm(7, "DSA", null, null, ANSI_X9_ALGORITHM.subBranch(1L));
    public static final SignatureAlgorithm ECSignature = new SignatureAlgorithm(44, "EC", null, null, ANSI_X962_OID.subBranch(2L).subBranch(1L));
    public static final SignatureAlgorithm RSASignatureWithMD2Digest = new SignatureAlgorithm(0, "RSASignatureWithMD2Digest", RSASignature, DigestAlgorithm.MD2, OBJECT_IDENTIFIER.PKCS1.subBranch(2L));
    public static final SignatureAlgorithm RSASignatureWithMD5Digest = new SignatureAlgorithm(1, "RSASignatureWithMD5Digest", RSASignature, DigestAlgorithm.MD5, OBJECT_IDENTIFIER.PKCS1.subBranch(4L));
    public static final SignatureAlgorithm RSASignatureWithSHA1Digest = new SignatureAlgorithm(2, "RSASignatureWithSHA1Digest", RSASignature, DigestAlgorithm.SHA1, OBJECT_IDENTIFIER.PKCS1.subBranch(5L));
    public static final SignatureAlgorithm DSASignatureWithSHA1Digest = new SignatureAlgorithm(3, "DSASignatureWithSHA1Digest", DSASignature, DigestAlgorithm.SHA1, ANSI_X9_ALGORITHM.subBranch(3L));
    public static final SignatureAlgorithm ECSignatureWithSHA1Digest = new SignatureAlgorithm(45, "ECSignatureWithSHA1Digest", ECSignature, DigestAlgorithm.SHA1, ANSI_X962_OID.subBranch(4L).subBranch(1L));
    public static final SignatureAlgorithm ECSignatureWithSHA256Digest = new SignatureAlgorithm(47, "ECSignatureWithSHA256Digest", ECSignature, DigestAlgorithm.SHA256, ANSI_X962_OID.subBranch(4L).subBranch(3L).subBranch(2L));
    public static final SignatureAlgorithm ECSignatureWithSHA384Digest = new SignatureAlgorithm(48, "ECSignatureWithSHA384Digest", ECSignature, DigestAlgorithm.SHA384, ANSI_X962_OID.subBranch(4L).subBranch(3L).subBranch(3L));
    public static final SignatureAlgorithm ECSignatureWithSHA512Digest = new SignatureAlgorithm(49, "ECSignatureWithSHA512Digest", ECSignature, DigestAlgorithm.SHA512, ANSI_X962_OID.subBranch(4L).subBranch(3L).subBranch(4L));
    public static final SignatureAlgorithm RSASignatureWithSHA256Digest = new SignatureAlgorithm(41, "RSASignatureWithSHA256Digest", RSASignature, DigestAlgorithm.SHA256, OBJECT_IDENTIFIER.PKCS1.subBranch(11L));
    public static final SignatureAlgorithm RSASignatureWithSHA384Digest = new SignatureAlgorithm(42, "RSASignatureWithSHA384Digest", RSASignature, DigestAlgorithm.SHA384, OBJECT_IDENTIFIER.PKCS1.subBranch(12L));
    public static final SignatureAlgorithm RSASignatureWithSHA512Digest = new SignatureAlgorithm(43, "RSASignatureWithSHA512Digest", RSASignature, DigestAlgorithm.SHA512, OBJECT_IDENTIFIER.PKCS1.subBranch(13L));

    protected SignatureAlgorithm(int oidIndex, String name, SignatureAlgorithm signingAlg, DigestAlgorithm digestAlg, OBJECT_IDENTIFIER oid) {
        super(oidIndex, name, oid);
        this.signingAlg = signingAlg == null ? this : signingAlg;
        this.digestAlg = digestAlg;
        oidMap.put(oid, this);
    }

    public static SignatureAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg2 = oidMap.get(oid);
        if (alg2 == null) {
            throw new NoSuchAlgorithmException();
        }
        return (SignatureAlgorithm)alg2;
    }

    public Algorithm getSigningAlg() {
        return this.signingAlg;
    }

    public SignatureAlgorithm getRawAlg() {
        return this.signingAlg;
    }

    public DigestAlgorithm getDigestAlg() throws NoSuchAlgorithmException {
        if (this.digestAlg == null) {
            throw new NoSuchAlgorithmException();
        }
        return this.digestAlg;
    }
}

