/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;

public interface SymmetricKey {
    public static final Type DES = Type.DES;
    public static final Type DES3 = Type.DES3;
    public static final Type RC4 = Type.RC4;
    public static final Type RC2 = Type.RC2;
    public static final Type SHA1_HMAC = Type.SHA1_HMAC;
    public static final Type AES = Type.AES;

    public Type getType();

    public CryptoToken getOwningToken();

    public int getStrength();

    public int getLength();

    public byte[] getKeyData() throws NotExtractableException;

    public String getAlgorithm();

    public byte[] getEncoded();

    public String getFormat();

    public static final class Usage {
        private int val;
        public static final Usage ENCRYPT = new Usage(0);
        public static final Usage DECRYPT = new Usage(1);
        public static final Usage WRAP = new Usage(2);
        public static final Usage UNWRAP = new Usage(3);
        public static final Usage SIGN = new Usage(4);
        public static final Usage VERIFY = new Usage(5);

        private Usage() {
        }

        private Usage(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }

    public static final class Type {
        private static Hashtable nameMap = new Hashtable();
        private String name;
        private KeyGenAlgorithm keyGenAlg;
        public static final Type DES = new Type("DES", KeyGenAlgorithm.DES);
        public static final Type DES3;
        public static final Type DESede;
        public static final Type RC4;
        public static final Type RC2;
        public static final Type SHA1_HMAC;
        public static final Type AES;

        private Type() {
        }

        private Type(String name, KeyGenAlgorithm keyGenAlg) {
            this.name = name;
            this.keyGenAlg = keyGenAlg;
            nameMap.put(name.toLowerCase(), this);
        }

        public String toString() {
            return this.name;
        }

        public KeyGenAlgorithm getKeyGenAlg() throws NoSuchAlgorithmException {
            if (this.keyGenAlg == null) {
                throw new NoSuchAlgorithmException(this.name);
            }
            return this.keyGenAlg;
        }

        public static Type fromName(String name) throws NoSuchAlgorithmException {
            Object type = nameMap.get(name.toLowerCase());
            if (type == null) {
                throw new NoSuchAlgorithmException();
            }
            return (Type)type;
        }

        static {
            DESede = DES3 = new Type("DESede", KeyGenAlgorithm.DES3);
            RC4 = new Type("RC4", KeyGenAlgorithm.RC4);
            RC2 = new Type("RC2", KeyGenAlgorithm.RC2);
            SHA1_HMAC = new Type("SHA1_HMAC", KeyGenAlgorithm.PBA_SHA1_HMAC);
            AES = new Type("AES", KeyGenAlgorithm.AES);
        }
    }

    public static class NotExtractableException
    extends Exception {
        public NotExtractableException() {
        }

        public NotExtractableException(String mesg) {
            super(mesg);
        }
    }
}

