/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs10;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class CertificationRequestInfo
implements ASN1Value {
    private INTEGER version = new INTEGER(0L);
    private Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private SET attributes;
    static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CertificationRequestInfo(INTEGER version, Name subject, SubjectPublicKeyInfo subjectPublicKeyInfo, SET attributes) {
        this.setVersion(version);
        this.setSubject(subject);
        this.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.setAttributes(attributes);
    }

    public void setVersion(INTEGER version) {
        this.verifyNotNull(version);
        this.version = version;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public void setSubject(Name subject) {
        this.verifyNotNull(subject);
        this.subject = subject;
    }

    public Name getSubject() {
        return this.subject;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.verifyNotNull(subjectPublicKeyInfo);
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(PublicKey pubk) throws InvalidBERException, IOException {
        this.verifyNotNull(pubk);
        this.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo(pubk));
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setAttributes(SET attributes) {
        this.attributes = attributes;
    }

    public SET getAttributes() {
        return this.attributes;
    }

    private void verifyNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.version);
        seq.addElement(this.subject);
        seq.addElement(this.subjectPublicKeyInfo);
        seq.addElement(new Tag(0L), this.attributes);
        seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void print(PrintStream ps) throws IOException, InvalidBERException {
        ps.println("CertificationRequestInfo:");
        ps.println("Version: " + this.version);
        ps.println("Subject: " + this.subject.getRFC1485());
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(SubjectPublicKeyInfo.getTemplate());
            this.seqt.addElement(Tag.get(0L), new SET.OF_Template(Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            try {
                SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
                CertificationRequestInfo cinfo = new CertificationRequestInfo((INTEGER)seq.elementAt(0), (Name)seq.elementAt(1), (SubjectPublicKeyInfo)seq.elementAt(2), (SET)seq.elementAt(3));
                return cinfo;
            }
            catch (Exception e) {
                throw new InvalidBERException(e.getMessage());
            }
        }
    }
}

