/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.CertProxy;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;

public class PK11Cert
implements X509Certificate {
    protected CertProxy certProxy;
    protected TokenProxy tokenProxy;
    protected String nickname;

    public native byte[] getEncoded() throws CertificateEncodingException;

    public String getNickname() {
        return this.nickname;
    }

    public Principal getSubjectDN() {
        return new StringPrincipal(this.getSubjectDNString());
    }

    public Principal getIssuerDN() {
        return new StringPrincipal(this.getIssuerDNString());
    }

    public BigInteger getSerialNumber() {
        return new BigInteger(this.getSerialNumberByteArray());
    }

    protected native byte[] getSerialNumberByteArray();

    protected native String getSubjectDNString();

    protected native String getIssuerDNString();

    public native PublicKey getPublicKey();

    public native int getVersion();

    protected native byte[] getUniqueID();

    protected native CryptoToken getOwningToken();

    protected native void setTrust(int var1, int var2);

    protected native int getTrust(int var1);

    PK11Cert(byte[] certPtr, byte[] slotPtr, String nickname) {
        Assert._assert(certPtr != null);
        Assert._assert(slotPtr != null);
        this.certProxy = new CertProxy(certPtr);
        this.tokenProxy = new TokenProxy(slotPtr);
        this.nickname = nickname;
    }

    protected static class StringPrincipal
    implements Principal {
        protected String str;

        public StringPrincipal(String str) {
            this.str = str;
        }

        public boolean equals(Object other) {
            if (!(other instanceof StringPrincipal)) {
                return false;
            }
            return this.getName().equals(((StringPrincipal)other).getName());
        }

        public String getName() {
            return this.str;
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }
    }
}

