/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.util.Assert;

public final class PK11DSAPublicKey
extends PK11PubKey
implements DSAPublicKey {
    public PK11DSAPublicKey(byte[] pointer) {
        super(pointer);
    }

    public DSAParams getParams() {
        try {
            BigInteger P = new BigInteger(this.getPByteArray());
            BigInteger Q = new BigInteger(this.getQByteArray());
            BigInteger G = new BigInteger(this.getGByteArray());
            return new DSAParameterSpec(P, Q, G);
        }
        catch (NumberFormatException e) {
            Assert.notReached("Unable to decode DSA parameters");
            return null;
        }
    }

    public BigInteger getY() {
        try {
            return new BigInteger(this.getYByteArray());
        }
        catch (NumberFormatException e) {
            Assert.notReached("Unable to decode DSA public value");
            return null;
        }
    }

    private native byte[] getPByteArray();

    private native byte[] getQByteArray();

    private native byte[] getGByteArray();

    private native byte[] getYByteArray();
}

