/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.RSAParameterSpec;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11ParameterSpec;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Assert;

public final class PK11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int CKF_ENCRYPT = 256;
    private static final int CKF_DECRYPT = 512;
    private static final int CKF_SIGN = 2048;
    private static final int CKF_SIGN_RECOVER = 4096;
    private static final int CKF_VERIFY = 8192;
    private static final int CKF_VERIFY_RECOVER = 16384;
    private static final int CKF_WRAP = 131072;
    private static final int CKF_UNWRAP = 262144;
    private static final int CKF_DERIVE = 524288;
    private static final int[] opFlagForUsage = new int[]{256, 512, 2048, 4096, 8192, 16384, 131072, 262144, 524288};
    private int opFlags = 0;
    private int opFlagsMask = 0;
    private static final int DEFAULT_RSA_KEY_SIZE = 2048;
    private static final BigInteger DEFAULT_RSA_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    private static final String p1024 = "135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571";
    private static final String q1024 = "1289225024022202541601051225376429063716419728261";
    private static final String g1024 = "9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969";
    private static final String h1024 = "52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473";
    private static final String seed1024 = "99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837";
    private static final int counter1024 = 159;
    public static final PQGParams PQG1024 = new PQGParams(new BigInteger("135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571"), new BigInteger("1289225024022202541601051225376429063716419728261"), new BigInteger("9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969"), new BigInteger("99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837"), 159, new BigInteger("52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473"));
    private static final String p768 = "1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183";
    private static final String q768 = "1356132865877303155992130272917916166541739006871";
    private static final String g768 = "1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163";
    private static final String seed768 = "818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797";
    private static final int counter768 = 80;
    private static final String h768 = "640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591";
    public static final PQGParams PQG768 = new PQGParams(new BigInteger("1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183"), new BigInteger("1356132865877303155992130272917916166541739006871"), new BigInteger("1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163"), new BigInteger("818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797"), 80, new BigInteger("640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591"));
    private static final String p512 = "6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841";
    private static final String q512 = "1310301134281640075932276656367326462518739803527";
    private static final String g512 = "1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884";
    private static final String h512 = "1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652";
    private static final String seed512 = "1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600";
    private static final int counter512 = 186;
    public static final PQGParams PQG512 = new PQGParams(new BigInteger("6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841"), new BigInteger("1310301134281640075932276656367326462518739803527"), new BigInteger("1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884"), new BigInteger("1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600"), 186, new BigInteger("1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652"));
    private static boolean defaultsTested = false;
    private static final OBJECT_IDENTIFIER ANSI_X962_PRIME_CURVE = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 10045L, 3L, 1L});
    private static final OBJECT_IDENTIFIER ANSI_X962_BINARY_CURVE = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 10045L, 3L, 0L});
    private static final OBJECT_IDENTIFIER SECG_EC_CURVE = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 132L, 0L});
    static final OBJECT_IDENTIFIER CURVE_ANSI_P192V1 = ANSI_X962_PRIME_CURVE.subBranch(1L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P192V2 = ANSI_X962_PRIME_CURVE.subBranch(2L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P192V3 = ANSI_X962_PRIME_CURVE.subBranch(3L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P239V1 = ANSI_X962_PRIME_CURVE.subBranch(4L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P239V2 = ANSI_X962_PRIME_CURVE.subBranch(5L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P239V3 = ANSI_X962_PRIME_CURVE.subBranch(6L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_P256V1 = ANSI_X962_PRIME_CURVE.subBranch(7L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB163V1 = ANSI_X962_BINARY_CURVE.subBranch(1L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB163V2 = ANSI_X962_BINARY_CURVE.subBranch(2L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB163V3 = ANSI_X962_BINARY_CURVE.subBranch(3L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB176V1 = ANSI_X962_BINARY_CURVE.subBranch(4L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB191V1 = ANSI_X962_BINARY_CURVE.subBranch(5L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB191V2 = ANSI_X962_BINARY_CURVE.subBranch(6L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB191V3 = ANSI_X962_BINARY_CURVE.subBranch(7L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_ONB191V4 = ANSI_X962_BINARY_CURVE.subBranch(8L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_ONB191V5 = ANSI_X962_BINARY_CURVE.subBranch(9L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB208W1 = ANSI_X962_BINARY_CURVE.subBranch(10L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB239V1 = ANSI_X962_BINARY_CURVE.subBranch(11L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB239V2 = ANSI_X962_BINARY_CURVE.subBranch(12L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB239V3 = ANSI_X962_BINARY_CURVE.subBranch(13L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_ONB239V4 = ANSI_X962_BINARY_CURVE.subBranch(14L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_ONB239V5 = ANSI_X962_BINARY_CURVE.subBranch(15L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB272W1 = ANSI_X962_BINARY_CURVE.subBranch(16L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB304W1 = ANSI_X962_BINARY_CURVE.subBranch(17L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB359V1 = ANSI_X962_BINARY_CURVE.subBranch(18L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_PNB368W1 = ANSI_X962_BINARY_CURVE.subBranch(19L);
    static final OBJECT_IDENTIFIER CURVE_ANSI_TNB431R1 = ANSI_X962_BINARY_CURVE.subBranch(20L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P112R1 = SECG_EC_CURVE.subBranch(6L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P112R2 = SECG_EC_CURVE.subBranch(7L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P128R1 = SECG_EC_CURVE.subBranch(28L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P128R2 = SECG_EC_CURVE.subBranch(29L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P160K1 = SECG_EC_CURVE.subBranch(9L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P160R1 = SECG_EC_CURVE.subBranch(8L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P160R2 = SECG_EC_CURVE.subBranch(30L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P192K1 = SECG_EC_CURVE.subBranch(31L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P224K1 = SECG_EC_CURVE.subBranch(32L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P224R1 = SECG_EC_CURVE.subBranch(33L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P256K1 = SECG_EC_CURVE.subBranch(10L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P384R1 = SECG_EC_CURVE.subBranch(34L);
    static final OBJECT_IDENTIFIER CURVE_SECG_P521R1 = SECG_EC_CURVE.subBranch(35L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T113R1 = SECG_EC_CURVE.subBranch(4L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T113R2 = SECG_EC_CURVE.subBranch(5L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T131R1 = SECG_EC_CURVE.subBranch(22L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T131R2 = SECG_EC_CURVE.subBranch(23L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T163K1 = SECG_EC_CURVE.subBranch(1L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T163R1 = SECG_EC_CURVE.subBranch(2L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T163R2 = SECG_EC_CURVE.subBranch(15L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T193R1 = SECG_EC_CURVE.subBranch(24L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T193R2 = SECG_EC_CURVE.subBranch(25L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T233K1 = SECG_EC_CURVE.subBranch(26L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T233R1 = SECG_EC_CURVE.subBranch(27L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T239K1 = SECG_EC_CURVE.subBranch(3L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T283K1 = SECG_EC_CURVE.subBranch(16L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T283R1 = SECG_EC_CURVE.subBranch(17L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T409K1 = SECG_EC_CURVE.subBranch(36L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T409R1 = SECG_EC_CURVE.subBranch(37L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T571K1 = SECG_EC_CURVE.subBranch(38L);
    static final OBJECT_IDENTIFIER CURVE_SECG_T571R1 = SECG_EC_CURVE.subBranch(39L);
    private PK11Token token;
    private AlgorithmParameterSpec params;
    private KeyPairAlgorithm algorithm;
    private boolean mKeygenOnInternalToken;
    private boolean temporaryPairMode = false;
    private int sensitivePairMode = -1;
    private int extractablePairMode = -1;

    public PK11KeyPairGenerator(PK11Token token, KeyPairAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(token != null && algorithm != null);
        this.mKeygenOnInternalToken = false;
        if (!token.doesAlgorithm(algorithm)) {
            if (token.doesAlgorithm(algorithm.getAlgFamily()) && token.isWritable()) {
                this.mKeygenOnInternalToken = true;
            } else {
                throw new NoSuchAlgorithmException();
            }
        }
        this.token = token;
        this.algorithm = algorithm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(int strength, SecureRandom random) throws InvalidParameterException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            this.params = new RSAParameterSpec(strength, DEFAULT_RSA_PUBLIC_EXPONENT);
            return;
        } else if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (strength == 512) {
                this.params = PQG512;
                return;
            } else if (strength == 768) {
                this.params = PQG768;
                return;
            } else {
                if (strength != 1024) throw new InvalidParameterException("In order to use pre-cooked PQG values, key strength mustbe 512, 768, or 1024.");
                this.params = PQG1024;
            }
            return;
        } else {
            Assert._assert(this.algorithm == KeyPairAlgorithm.EC);
            this.params = this.getCurve(strength);
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null) {
            Assert.notReached("Don't pass in null parameters");
            throw new InvalidAlgorithmParameterException();
        }
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (!(params instanceof RSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            if (((RSAParameterSpec)params).getPublicExponent().bitLength() > 31) {
                throw new InvalidAlgorithmParameterException("RSA Public Exponent must fit in 31 or fewer bits.");
            }
        } else if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
        } else {
            Assert._assert(this.algorithm == KeyPairAlgorithm.EC);
            if (!(params instanceof PK11ParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
        }
        this.params = params;
    }

    public KeyPair generateKeyPair() throws TokenException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (this.params != null) {
                RSAParameterSpec rsaparams = (RSAParameterSpec)this.params;
                return this.generateRSAKeyPairWithOpFlags(this.token, rsaparams.getKeySize(), rsaparams.getPublicExponent().longValue(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, this.opFlags, this.opFlagsMask);
            }
            return this.generateRSAKeyPairWithOpFlags(this.token, 2048, DEFAULT_RSA_PUBLIC_EXPONENT.longValue(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, this.opFlags, this.opFlagsMask);
        }
        if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (this.params == null) {
                this.params = PQG1024;
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)this.params;
            return this.generateDSAKeyPairWithOpFlags(this.token, PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getP()), PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getQ()), PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getG()), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, this.opFlags, this.opFlagsMask);
        }
        Assert._assert(this.algorithm == KeyPairAlgorithm.EC);
        PK11ParameterSpec ecParams = (PK11ParameterSpec)this.params;
        return this.generateECKeyPairWithOpFlags(this.token, ecParams.getEncoded(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, this.opFlags, this.opFlagsMask);
    }

    public boolean keygenOnInternalToken() {
        return this.mKeygenOnInternalToken;
    }

    private native KeyPair generateRSAKeyPair(PK11Token var1, int var2, long var3, boolean var5, int var6, int var7) throws TokenException;

    private native KeyPair generateRSAKeyPairWithOpFlags(PK11Token var1, int var2, long var3, boolean var5, int var6, int var7, int var8, int var9) throws TokenException;

    private native KeyPair generateDSAKeyPair(PK11Token var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, int var6, int var7) throws TokenException;

    private native KeyPair generateDSAKeyPairWithOpFlags(PK11Token var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, int var6, int var7, int var8, int var9) throws TokenException;

    private native KeyPair generateECKeyPair(PK11Token var1, byte[] var2, boolean var3, int var4, int var5) throws TokenException;

    private native KeyPair generateECKeyPairWithOpFlags(PK11Token var1, byte[] var2, boolean var3, int var4, int var5, int var6, int var7) throws TokenException;

    private static synchronized void testDefaults() {
        if (!defaultsTested) {
            Assert._assert(PQG1024.paramsAreValid());
            Assert._assert(PQG768.paramsAreValid());
            Assert._assert(PQG512.paramsAreValid());
            defaultsTested = true;
        }
    }

    public void temporaryPairs(boolean temp) {
        this.temporaryPairMode = temp;
    }

    public void sensitivePairs(boolean sensitive) {
        this.sensitivePairMode = sensitive ? 1 : 0;
    }

    public void extractablePairs(boolean extractable) {
        this.extractablePairMode = extractable ? 1 : 0;
    }

    public void setKeyPairUsages(KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usages_mask) {
        int i;
        this.opFlags = 0;
        this.opFlagsMask = 0;
        if (usages != null) {
            for (i = 0; i < usages.length; ++i) {
                if (usages[i] == null) continue;
                this.opFlags |= opFlagForUsage[usages[i].getVal()];
            }
        }
        if (usages_mask != null) {
            for (i = 0; i < usages_mask.length; ++i) {
                if (usages_mask[i] == null) continue;
                this.opFlagsMask |= opFlagForUsage[usages_mask[i].getVal()];
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private AlgorithmParameterSpec getCurve(int strength) throws InvalidParameterException {
        void var2_2;
        switch (strength) {
            case 112: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P112R1;
                break;
            }
            case 113: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T113R1;
                break;
            }
            case 128: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P128R1;
                break;
            }
            case 131: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T131R1;
                break;
            }
            case 160: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P160R1;
                break;
            }
            case 163: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T163K1;
                break;
            }
            case 176: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_PNB176V1;
                break;
            }
            case 191: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_TNB191V1;
                break;
            }
            case 192: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_P192V1;
                break;
            }
            case 193: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T193R1;
                break;
            }
            case 208: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_PNB208W1;
                break;
            }
            case 224: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P224R1;
                break;
            }
            case 233: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T233R1;
                break;
            }
            case 239: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T239K1;
                break;
            }
            case 256: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_P256V1;
                break;
            }
            case 272: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_PNB272W1;
                break;
            }
            case 283: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T283R1;
                break;
            }
            case 304: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_PNB304W1;
                break;
            }
            case 359: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_TNB359V1;
                break;
            }
            case 368: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_PNB368W1;
                break;
            }
            case 384: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P384R1;
                break;
            }
            case 409: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T409R1;
                break;
            }
            case 431: {
                OBJECT_IDENTIFIER oid = CURVE_ANSI_TNB431R1;
                break;
            }
            case 521: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_P521R1;
                break;
            }
            case 571: {
                OBJECT_IDENTIFIER oid = CURVE_SECG_T571R1;
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
        return new PK11ParameterSpec(ASN1Util.encode((ASN1Value)var2_2));
    }
}

