/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.CipherContextProxy;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;

public final class PK11MessageDigest
extends JSSMessageDigest {
    private PK11Token token;
    private CipherContextProxy digestProxy;
    private PK11SymKey hmacKey;
    private DigestAlgorithm alg;

    PK11MessageDigest(PK11Token token, DigestAlgorithm alg2) throws NoSuchAlgorithmException, DigestException {
        this.token = token;
        this.alg = alg2;
        if (!token.doesAlgorithm(alg2)) {
            throw new NoSuchAlgorithmException();
        }
        this.reset();
    }

    public void initHMAC(SymmetricKey key) throws DigestException, InvalidKeyException {
        if (!(this.alg instanceof HMACAlgorithm)) {
            throw new DigestException("Digest is not an HMAC digest");
        }
        this.reset();
        if (!(key instanceof PK11SymKey)) {
            throw new InvalidKeyException("HMAC key is not a PKCS #11 key");
        }
        this.hmacKey = (PK11SymKey)key;
        if (!((Object)key.getOwningToken()).equals(this.token)) {
            this.hmacKey = null;
            throw new InvalidKeyException("HMAC key does not live on the same token as this digest");
        }
        this.digestProxy = PK11MessageDigest.initHMAC(this.token, this.alg, this.hmacKey);
    }

    public void update(byte[] input, int offset, int len) throws DigestException {
        if (this.digestProxy == null) {
            throw new DigestException("Digest not correctly initialized");
        }
        if (input.length < offset + len) {
            throw new IllegalArgumentException("Input buffer is not large enough for offset and length");
        }
        PK11MessageDigest.update(this.digestProxy, input, offset, len);
    }

    public int digest(byte[] outbuf, int offset, int len) throws DigestException {
        if (this.digestProxy == null) {
            throw new DigestException("Digest not correctly initialized");
        }
        if (outbuf.length < offset + len) {
            throw new IllegalArgumentException("Output buffer is not large enough for offset and length");
        }
        int retval = PK11MessageDigest.digest(this.digestProxy, outbuf, offset, len);
        this.reset();
        return retval;
    }

    public void reset() throws DigestException {
        this.digestProxy = !(this.alg instanceof HMACAlgorithm) ? PK11MessageDigest.initDigest(this.alg) : (this.hmacKey != null ? PK11MessageDigest.initHMAC(this.token, this.alg, this.hmacKey) : null);
    }

    public DigestAlgorithm getAlgorithm() {
        return this.alg;
    }

    private static native CipherContextProxy initDigest(DigestAlgorithm var0) throws DigestException;

    private static native CipherContextProxy initHMAC(PK11Token var0, DigestAlgorithm var1, PK11SymKey var2) throws DigestException;

    private static native void update(CipherContextProxy var0, byte[] var1, int var2, int var3);

    private static native int digest(CipherContextProxy var0, byte[] var1, int var2, int var3);
}

