/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PrivateKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PrivKey
extends PK11Key
implements PrivateKey {
    private PK11PrivKey() {
    }

    protected PK11PrivKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new PrivateKeyProxy(pointer);
    }

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;

    public native CryptoToken getOwningToken();

    public native byte[] getUniqueID() throws TokenException;

    public native KeyType getKeyType();

    public PrivateKey.Type getType() {
        KeyType kt = this.getKeyType();
        if (kt == KeyType.RSA) {
            return PrivateKey.Type.RSA;
        }
        if (kt == KeyType.DSA) {
            return PrivateKey.Type.DSA;
        }
        Assert._assert(kt == KeyType.EC);
        return PrivateKey.Type.EC;
    }

    public String getAlgorithm() {
        return this.getType().toString();
    }

    public native int getStrength();

    public static PK11PrivKey fromPrivateKeyInfo(PKCS8EncodedKeySpec spec, CryptoToken token) throws TokenException {
        return PK11PrivKey.fromPrivateKeyInfo(spec.getEncoded(), token);
    }

    public static PK11PrivKey fromPrivateKeyInfo(byte[] pki, CryptoToken token) throws TokenException {
        return PK11PrivKey.fromPrivateKeyInfo(pki, token, null);
    }

    public static native PK11PrivKey fromPrivateKeyInfo(byte[] var0, CryptoToken var1, byte[] var2) throws TokenException;

    protected DSAParameterSpec getDSAParams() throws TokenException {
        byte[][] pqgArray = this.getDSAParamsNative();
        return new DSAParameterSpec(new BigInteger(pqgArray[0]), new BigInteger(pqgArray[1]), new BigInteger(pqgArray[2]));
    }

    private native byte[][] getDSAParamsNative() throws TokenException;
}

