/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.PublicKey;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PublicKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PubKey
extends PK11Key
implements PublicKey {
    protected PK11PubKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new PublicKeyProxy(pointer);
    }

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;

    public native KeyType getKeyType();

    public String getAlgorithm() {
        return this.getKeyType().toString();
    }

    public static PK11PubKey fromRaw(PrivateKey.Type type, byte[] rawKey) throws InvalidKeyFormatException {
        if (type != PrivateKey.Type.RSA) {
            throw new InvalidKeyFormatException("fromRaw() is broken for DSA keys. Use fromSPKI() instead.");
        }
        return PK11PubKey.fromRawNative(type.getPKCS11Type(), rawKey);
    }

    private static native PK11PubKey fromRawNative(int var0, byte[] var1) throws InvalidKeyFormatException;

    public static native PK11PubKey fromSPKI(byte[] var0) throws InvalidKeyFormatException;

    private static native PK11PubKey RSAFromRaw(byte[] var0);

    private static native PK11PubKey DSAFromRaw(byte[] var0);

    public native byte[] getEncoded();

    public String getFormat() {
        return "X.509";
    }
}

