/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SignatureSpi;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.SigContextProxy;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;

final class PK11Signature
extends SignatureSpi {
    protected PK11Token token;
    protected TokenProxy tokenProxy;
    protected Algorithm algorithm;
    protected PK11Key key;
    protected int state;
    protected SigContextProxy sigContext;
    protected boolean raw = false;
    protected ByteArrayOutputStream rawInput;
    public static final int UNINITIALIZED = 0;
    public static final int SIGN = 1;
    public static final int VERIFY = 2;

    public PK11Signature(PK11Token token, SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(token != null && algorithm != null);
        if (!token.doesAlgorithm(algorithm) && !token.doesAlgorithm(algorithm.getSigningAlg())) {
            throw new NoSuchAlgorithmException();
        }
        this.tokenProxy = token.getProxy();
        this.token = token;
        this.algorithm = algorithm;
        if (algorithm.getRawAlg() == algorithm) {
            this.raw = true;
            this.rawInput = new ByteArrayOutputStream();
        }
        this.state = 0;
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException, TokenException {
        Assert._assert(privateKey != null);
        if (privateKey == null) {
            throw new InvalidKeyException("private key is null");
        }
        if (!(privateKey instanceof PK11PrivKey)) {
            throw new InvalidKeyException("privateKey is not a PKCS #11 private key");
        }
        PK11PrivKey privKey = (PK11PrivKey)privateKey;
        try {
            privKey.verifyKeyIsOnToken(this.token);
        }
        catch (NoSuchItemOnTokenException e) {
            throw new InvalidKeyException(e.toString());
        }
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != privKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException e) {
            Assert.notReached("unknown algorithm: " + this.algorithm);
            throw new InvalidKeyException();
        }
        this.key = privKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initSigContext();
        }
        this.state = 1;
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException, TokenException {
        Assert.notReached("This function is not supported");
        this.engineInitSign(privateKey);
    }

    protected native void initSigContext() throws TokenException;

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException, TokenException {
        Assert._assert(publicKey != null);
        if (!(publicKey instanceof PK11PubKey)) {
            throw new InvalidKeyException("publicKey is not a PKCS #11 public key");
        }
        PK11PubKey pubKey = (PK11PubKey)publicKey;
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != pubKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException e) {
            Assert.notReached("unknown algorithm: " + this.algorithm);
            throw new InvalidKeyException();
        }
        this.key = pubKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initVfyContext();
        }
        this.state = 2;
    }

    protected native void initVfyContext() throws TokenException;

    public void engineUpdate(byte b) throws SignatureException, TokenException {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    public void engineUpdate(byte[] b, int off, int len) throws SignatureException, TokenException {
        Assert._assert(b != null);
        if (this.state == 1 || this.state == 2) {
            if (!this.raw && this.sigContext == null) {
                Assert.notReached("signature has no context");
                throw new SignatureException("Signature has no context");
            }
            if (this.raw && this.rawInput == null) {
                Assert.notReached("raw signature has no input stream");
                throw new SignatureException("raw signature has no input stream");
            }
        } else {
            Assert._assert(this.state == 0);
            throw new SignatureException("Signature is not initialized");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (this.raw) {
            this.rawInput.write(b, off, len);
        } else {
            this.engineUpdateNative(b, off, len);
        }
    }

    protected native void engineUpdateNative(byte[] var1, int var2, int var3) throws TokenException;

    public byte[] engineSign() throws SignatureException, TokenException {
        byte[] result;
        if (this.state != 1) {
            throw new SignatureException("Signature is not initialized");
        }
        if (!this.raw && this.sigContext == null) {
            throw new SignatureException("Signature has no context");
        }
        if (this.raw && this.rawInput == null) {
            throw new SignatureException("Signature has no input");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (this.raw) {
            result = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            result = this.engineSignNative();
        }
        this.state = 0;
        this.sigContext = null;
        return result;
    }

    public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException, TokenException {
        byte[] sig;
        Assert._assert(outbuf != null);
        if (this.raw) {
            sig = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            sig = this.engineSign();
        }
        if (outbuf == null || outbuf.length <= offset || len < sig.length || offset + len > outbuf.length) {
            throw new SignatureException("outbuf is not sufficient to hold signature");
        }
        System.arraycopy(sig, 0, outbuf, offset, sig.length);
        return sig.length;
    }

    private static native byte[] engineRawSignNative(PK11Token var0, PrivateKey var1, byte[] var2) throws SignatureException, TokenException;

    private native byte[] engineSignNative() throws SignatureException, TokenException;

    public boolean engineVerify(byte[] sigBytes) throws SignatureException, TokenException {
        boolean result;
        Assert._assert(sigBytes != null);
        if (this.state != 2) {
            throw new SignatureException("Signature is not initialized properly");
        }
        if (!this.raw && this.sigContext == null) {
            Assert.notReached("Signature has no context");
            throw new SignatureException("Signature has no context");
        }
        if (this.raw && this.rawInput == null) {
            Assert.notReached("Signature has no input");
            throw new SignatureException("Signature has no input");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (sigBytes == null) {
            return false;
        }
        if (this.raw) {
            result = PK11Signature.engineRawVerifyNative(this.token, (PK11PubKey)this.key, this.rawInput.toByteArray(), sigBytes);
            this.rawInput.reset();
        } else {
            result = this.engineVerifyNative(sigBytes);
        }
        this.state = 0;
        this.sigContext = null;
        return result;
    }

    protected static native boolean engineRawVerifyNative(PK11Token var0, PublicKey var1, byte[] var2, byte[] var3) throws SignatureException, TokenException;

    protected native boolean engineVerifyNative(byte[] var1) throws SignatureException, TokenException;

    public void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, TokenException {
        Assert.notYetImplemented("PK11Signature.engineSetParameter");
    }
}

