/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.util.Vector;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.KeyAlreadyImportedException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public final class PK11Store
implements CryptoStore {
    protected boolean updated;
    protected TokenProxy storeProxy;

    public native void importPrivateKey(byte[] var1, PrivateKey.Type var2) throws TokenException, KeyAlreadyImportedException;

    public synchronized PrivateKey[] getPrivateKeys() throws TokenException {
        Vector keys = new Vector();
        this.putKeysInVector(keys);
        PrivateKey[] array = new PrivateKey[keys.size()];
        keys.copyInto(array);
        return array;
    }

    protected native void putKeysInVector(Vector var1) throws TokenException;

    public native void deletePrivateKey(PrivateKey var1) throws NoSuchItemOnTokenException, TokenException;

    public native byte[] getEncryptedPrivateKeyInfo(X509Certificate var1, PBEAlgorithm var2, Password var3, int var4);

    public X509Certificate[] getCertificates() throws TokenException {
        Vector certs = new Vector();
        this.putCertsInVector(certs);
        X509Certificate[] array = new X509Certificate[certs.size()];
        certs.copyInto(array);
        return array;
    }

    protected native void putCertsInVector(Vector var1) throws TokenException;

    public native void deleteCert(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    public native void deleteCertOnly(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    public PK11Store(TokenProxy proxy) {
        Assert._assert(proxy != null);
        this.storeProxy = proxy;
    }

    protected PK11Store() {
    }
}

