/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.SymKeyProxy;
import org.mozilla.jss.util.Assert;

public final class PK11SymKey
implements SymmetricKey {
    private SymKeyProxy keyProxy;

    protected PK11SymKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new SymKeyProxy(pointer);
    }

    public SymmetricKey.Type getType() {
        KeyType kt = this.getKeyType();
        if (kt == KeyType.DES) {
            return SymmetricKey.DES;
        }
        if (kt == KeyType.DES3) {
            return SymmetricKey.DES3;
        }
        if (kt == KeyType.RC4) {
            return SymmetricKey.RC4;
        }
        if (kt == KeyType.RC2) {
            return SymmetricKey.RC2;
        }
        if (kt == KeyType.AES) {
            return SymmetricKey.AES;
        }
        if (kt == KeyType.SHA1_HMAC) {
            return SymmetricKey.SHA1_HMAC;
        }
        Assert.notReached("Unrecognized key type");
        return SymmetricKey.DES;
    }

    public native CryptoToken getOwningToken();

    public native int getStrength();

    public native int getLength();

    public native byte[] getKeyData() throws SymmetricKey.NotExtractableException;

    public native KeyType getKeyType();

    public String getAlgorithm() {
        return this.getKeyType().toString();
    }

    public byte[] getEncoded() {
        try {
            return this.getKeyData();
        }
        catch (SymmetricKey.NotExtractableException nee) {
            return null;
        }
    }

    public String getFormat() {
        return "RAW";
    }
}

