/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Cipher;
import org.mozilla.jss.pkcs11.PK11KeyGenerator;
import org.mozilla.jss.pkcs11.PK11KeyPairGenerator;
import org.mozilla.jss.pkcs11.PK11KeyWrapper;
import org.mozilla.jss.pkcs11.PK11MessageDigest;
import org.mozilla.jss.pkcs11.PK11Signature;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.TokenCallbackInfo;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.pkcs11.Tunnel;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.NotImplementedException;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public final class PK11Token
implements CryptoToken {
    protected boolean mIsInternalCryptoToken;
    protected boolean mIsInternalKeyStorageToken;
    protected TokenProxy tokenProxy;
    protected PK11Store cryptoStore;

    public Signature getSignatureContext(SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(algorithm != null);
        return Tunnel.constructSignature(algorithm, new PK11Signature(this, algorithm));
    }

    public JSSMessageDigest getDigestContext(DigestAlgorithm algorithm) throws NoSuchAlgorithmException, DigestException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException();
        }
        return new PK11MessageDigest(this, algorithm);
    }

    public Cipher getCipherContext(EncryptionAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm + " is not supported by this token");
        }
        return new PK11Cipher(this, algorithm);
    }

    public KeyGenerator getKeyGenerator(KeyGenAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm + " is not supported by this token");
        }
        return new PK11KeyGenerator(this, algorithm);
    }

    public SymmetricKey cloneKey(SymmetricKey key) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(key, this);
    }

    public KeyWrapper getKeyWrapper(KeyWrapAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm + " is not supported by this token");
        }
        return new PK11KeyWrapper(this, algorithm);
    }

    public SecureRandom getRandomGenerator() throws NotImplementedException, TokenException {
        throw new NotImplementedException();
    }

    public KeyPairGenerator getKeyPairGenerator(KeyPairAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(algorithm != null);
        return new KeyPairGenerator(algorithm, new PK11KeyPairGenerator(this, algorithm));
    }

    public native boolean isLoggedIn() throws TokenException;

    public native boolean needsLogin() throws TokenException;

    public void login(PasswordCallback callback) throws NotInitializedException, IncorrectPasswordException, TokenException {
        if (callback == null) {
            callback = new NullPasswordCallback();
        }
        this.nativeLogin(callback);
    }

    protected native void nativeLogin(PasswordCallback var1) throws NotInitializedException, IncorrectPasswordException, TokenException;

    public native boolean isWritable();

    public native boolean isPresent();

    public native void logout() throws TokenException;

    public native int getLoginMode() throws TokenException;

    public native void setLoginMode(int var1) throws TokenException;

    public native int getLoginTimeoutMinutes() throws TokenException;

    public native void setLoginTimeoutMinutes(int var1) throws TokenException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPassword(PasswordCallback ssopwcb, PasswordCallback userpwcb) throws IncorrectPasswordException, AlreadyInitializedException, TokenException {
        Password userpw;
        Password ssopw;
        byte[] userpwArray;
        block16: {
            byte[] ssopwArray = null;
            userpwArray = null;
            ssopw = null;
            userpw = null;
            PasswordCallbackInfo pwcb = this.makePWCBInfo();
            if (ssopwcb == null) {
                ssopwcb = new NullPasswordCallback();
            }
            if (userpwcb == null) {
                userpwcb = new NullPasswordCallback();
            }
            try {
                try {
                    if (!this.PWInitable()) {
                        throw new AlreadyInitializedException();
                    }
                    if (this.isInternalKeyStorageToken()) {
                        ssopwArray = new byte[]{0};
                    } else {
                        ssopw = ssopwcb.getPasswordFirstAttempt(pwcb);
                        ssopwArray = Tunnel.getPasswordByteCopy(ssopw);
                        while (!this.SSOPasswordIsCorrect(ssopwArray)) {
                            Password.wipeBytes(ssopwArray);
                            ssopw.clear();
                            ssopw = ssopwcb.getPasswordAgain(pwcb);
                            ssopwArray = Tunnel.getPasswordByteCopy(ssopw);
                        }
                    }
                    userpw = userpwcb.getPasswordFirstAttempt(pwcb);
                    userpwArray = Tunnel.getPasswordByteCopy(userpw);
                    this.initPassword(ssopwArray, userpwArray);
                }
                catch (PasswordCallback.GiveUpException e) {
                    throw new IncorrectPasswordException(e.toString());
                }
                Object var10_8 = null;
                if (ssopwArray == null) break block16;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (ssopwArray != null) {
                    Password.wipeBytes(ssopwArray);
                }
                if (ssopw != null) {
                    ssopw.clear();
                }
                if (userpwArray != null) {
                    Password.wipeBytes(userpwArray);
                }
                if (userpw == null) throw throwable;
                userpw.clear();
                throw throwable;
            }
            Password.wipeBytes(ssopwArray);
        }
        if (ssopw != null) {
            ssopw.clear();
        }
        if (userpwArray != null) {
            Password.wipeBytes(userpwArray);
        }
        if (userpw == null) return;
        userpw.clear();
    }

    protected native boolean PWInitable() throws TokenException;

    protected native boolean SSOPasswordIsCorrect(byte[] var1) throws TokenException, AlreadyInitializedException;

    protected native void initPassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, AlreadyInitializedException, TokenException;

    public native boolean passwordIsInitialized() throws TokenException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changePassword(PasswordCallback oldPINcb, PasswordCallback newPINcb) throws IncorrectPasswordException, TokenException {
        Password newPIN;
        Password oldPIN;
        byte[] newPW;
        block14: {
            byte[] oldPW = null;
            newPW = null;
            oldPIN = null;
            newPIN = null;
            PasswordCallbackInfo pwcb = this.makePWCBInfo();
            if (oldPINcb == null) {
                oldPINcb = new NullPasswordCallback();
            }
            if (newPINcb == null) {
                newPINcb = new NullPasswordCallback();
            }
            try {
                try {
                    oldPIN = oldPINcb.getPasswordFirstAttempt(pwcb);
                    oldPW = Tunnel.getPasswordByteCopy(oldPIN);
                    if (!this.userPasswordIsCorrect(oldPW)) {
                        do {
                            Password.wipeBytes(oldPW);
                            oldPIN.clear();
                        } while (!this.userPasswordIsCorrect(oldPW = Tunnel.getPasswordByteCopy(oldPIN = oldPINcb.getPasswordAgain(pwcb))));
                    }
                    newPIN = newPINcb.getPasswordFirstAttempt(pwcb);
                    newPW = Tunnel.getPasswordByteCopy(newPIN);
                    this.changePassword(oldPW, newPW);
                }
                catch (PasswordCallback.GiveUpException e) {
                    throw new IncorrectPasswordException(e.toString());
                }
                Object var10_8 = null;
                if (oldPW == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (oldPW != null) {
                    Password.wipeBytes(oldPW);
                }
                if (oldPIN != null) {
                    oldPIN.clear();
                }
                if (newPW != null) {
                    Password.wipeBytes(newPW);
                }
                if (newPIN == null) throw throwable;
                newPIN.clear();
                throw throwable;
            }
            Password.wipeBytes(oldPW);
        }
        if (oldPIN != null) {
            oldPIN.clear();
        }
        if (newPW != null) {
            Password.wipeBytes(newPW);
        }
        if (newPIN == null) return;
        newPIN.clear();
    }

    protected PasswordCallbackInfo makePWCBInfo() {
        return new TokenCallbackInfo(this.getName());
    }

    protected native boolean userPasswordIsCorrect(byte[] var1) throws TokenException;

    protected native void changePassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, TokenException;

    public native String getName();

    public Provider getProvider() {
        Assert.notYetImplemented("Providers not implemented by PK11Token yet");
        return null;
    }

    public CryptoStore getCryptoStore() {
        return this.cryptoStore;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PK11Token)) {
            return false;
        }
        return this.tokenProxy.equals(((PK11Token)obj).tokenProxy);
    }

    public native boolean doesAlgorithm(Algorithm var1);

    public String generateCertRequest(String subject, int keysize, String keyType, byte[] P, byte[] Q, byte[] G) throws TokenException, InvalidParameterException, PQGParamGenException {
        String pk10String;
        if (keyType.equalsIgnoreCase("dsa")) {
            if (P == null && Q == null && G == null) {
                String pk10String2;
                PQGParams pqg = PQGParams.generate(keysize);
                byte[] p = PQGParams.BigIntegerToUnsignedByteArray(pqg.getP());
                byte[] q = PQGParams.BigIntegerToUnsignedByteArray(pqg.getQ());
                byte[] g = PQGParams.BigIntegerToUnsignedByteArray(pqg.getG());
                P = p;
                Q = q;
                G = g;
                try {
                    pk10String2 = this.generatePK10(subject, keysize, keyType, p, q, g);
                }
                catch (TokenException e) {
                    throw e;
                }
                catch (InvalidParameterException e) {
                    throw e;
                }
                return "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + pk10String2 + "\n-----END NEW CERTIFICATE REQUEST-----";
            }
            if (P == null || Q == null || G == null) {
                throw new InvalidParameterException("need all P, Q, and G");
            }
        }
        try {
            pk10String = this.generatePK10(subject, keysize, keyType, P, Q, G);
        }
        catch (TokenException e) {
            throw e;
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        return "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + pk10String + "\n-----END NEW CERTIFICATE REQUEST-----";
    }

    protected native String generatePK10(String var1, int var2, String var3, byte[] var4, byte[] var5, byte[] var6) throws TokenException, InvalidParameterException;

    protected PK11Token() {
        Assert._assert(false);
    }

    protected PK11Token(byte[] pointer, boolean internal, boolean keyStorage) {
        Assert._assert(pointer != null);
        this.tokenProxy = new TokenProxy(pointer);
        this.mIsInternalCryptoToken = internal;
        this.mIsInternalKeyStorageToken = keyStorage;
        this.cryptoStore = new PK11Store(this.tokenProxy);
    }

    public TokenProxy getProxy() {
        return this.tokenProxy;
    }

    public boolean isInternalCryptoToken() {
        return this.mIsInternalCryptoToken;
    }

    public boolean isInternalKeyStorageToken() {
        return this.mIsInternalKeyStorageToken;
    }

    public static class NotInitializedException
    extends IncorrectPasswordException {
        public NotInitializedException() {
        }

        public NotInitializedException(String mesg) {
            super(mesg);
        }
    }
}

